cap log close
cap drop _all
set more off
# delimit ;
log using c:\aamortality102716\dofiles\graph_fig1_11.log , replace;
/* graph PSL by education and sex 1998-2015 */

use c:\aamortality102716\outfiles\WNHrates_sex_5yr_state_ed_9215.dta;
keep if year>=1998 ;
gen PSL = Prate+Srate+Lrate;

/* graph PSL rates for edclass=1 and edclass==3 for men and women separately */
keep if age==50;

gr two  (line PSL year if sex==1 & edclass==1,  lcolor(blue) lwidth(thick))
        (line PSL year if sex==2 & edclass==1,  lcolor(red) lwidth(thick))
        (line PSL year if sex==1 & edclass==3,  lcolor(blue) lwidth(thick) lpattern(longdash))
        (line PSL year if sex==2 & edclass==3,  lcolor(red) lwidth(thick) lpattern(longdash)),
        graphregion(color(white)) legend(off) xtitle(age) ytitle("deaths per 100,000") xtitle(year)
        xlabel(2000 2005 2010 2015)
        title("Drug, alcohol and suicide mortality, white non-Hispanics ages 50-54", color(black) size(med))
        saving(c:\users\accase\dropbox\brookings\archive\figures\fig1_11.gph, replace);

log close; stop;
