set more off
cap log close
cap drop _all
# delimit ;
log using c:\users\accase\dropbox\acs\data\cdc_9915_5yr_sex\dofiles\read_WNH_BNH_Trate_5yr_sex.log, replace;
/* reading all-cause mortality data from CDC Wonder for WNH, BNH and Hispanics by five year age group 1999-2015 pulled 12.8.16 */

use ..\data\WNH_Trate_5yr_sex_9915 ;
gen race=1;
ren Crude Trate;
ren Deaths TDeaths;
do prep_vars_1 ;
keep year age_gp sex race Trate TDeaths Population ;
save ..\data\WNH_BNH_Trate_5yr_sex.dta, replace;

use ..\data\BNH_Trate_5yr_sex_9915 ;
gen race=2;
ren Crude Trate;
ren Deaths TDeaths;
do prep_vars_1 ;
keep year age_gp sex race Trate TDeaths Population ;
merge 1:1 year sex race age_gp using ..\data\WNH_BNH_Trate_5yr_sex.dta;
drop _m;
save ..\data\WNH_BNH_Trate_5yr_sex.dta, replace;


use ..\data\Hisp_Trate_5yr_sex_9915 ;
gen race=3;
ren Crude Trate;
ren Deaths TDeaths;
do prep_vars_1 ;
keep year age_gp sex race Trate TDeaths Population ;
merge 1:1 year sex race age_gp using ..\data\WNH_BNH_Trate_5yr_sex.dta;
drop _m;
save ..\data\WNH_BNH_Trate_5yr_sex.dta, replace;

/********************************************************************/
/* now for sexes together: rates for sex=0 (men and women combined) */
drop sex;
bysort year race age_gp: egen TotPop= total(Population);
bysort year race age_gp: egen TDeaths_tot = total(TDeaths);
bysort year race age_gp: keep if _n==1;
gen sex=0;

gen Trate_all = TDeaths_tot *100000/TotPop;

keep year race age_gp sex Trate_all TDeaths_tot TotPop ;

ren TDeaths_tot TDeaths;
ren Trate_all Trate;
ren TotPop Population ;

merge 1:1 year race age_gp sex using ..\data\WNH_BNH_Trate_5yr_sex;
drop _m;
save ..\data\WNH_BNH_Trate_5yr_sex.dta, replace;


log close;
stop;
