
version 13.1
#delimit ;
cap log close;

clear;
drop _all;
*cd "C:\Users\accase\dropbox\Mortality by cause by country by year";
log using dofiles\process_who_icd9_AC.log, replace;
/* changing Bcodes that go into heart disease and adding countries*/
/* otherwise file is untouched */

set more off;
tempfile temp;
use infiles\morticd9;

* we only want to keep specific countries:;

	keep if inlist(country,2450,4308,4085,4090,4100,4120,4080,2090,5020,4290,4240,
4170,4140,4280,3160,4180,4070,4010,4020,4038,4045,4055,4070,4150,4160,4210,4220,4230,4300, 4274, 4276,4030,3080,4188,4190,4186,4200,4270,4050,4330);

	
*Prepare the data;
   *drop if sex not male or female;
   	drop if sex==9;

	sort country;
	
	gen str1 let_1=substr(cause,1,1);
	gen num_3=real(substr(cause,2,3));



	sort country year sex;
	*get country names;
	merge m:1 country using infiles\country_codes;
		*drop countries we are not using;
		
		drop if _m==2;
		drop _m;
		rename name country_name;
	labmask country, values(country_name);
	numlabel,add;
	
	*deaths;	
		gen deaths_all=deaths1;
		gen deaths_uns=deaths26;
		rename	deaths9	deaaths15_19;
		rename	deaths10 deaths20_24;
		rename	deaths11	deaths25_29;
		rename	deaths12	deaths30_34;
		rename	deaths13	deaths35_39;
		rename	deaths14	deaths40_44;
		rename	deaths15	deaths45_49;
		rename	deaths16	deaths50_54;
		rename	deaths17	deaths55_59;
		rename	deaths18	deaths60_64;
		rename	deaths19	deaths65_69;
		rename	deaths20	deaths70_74;
				
		drop   subdiv frmat admin deaths1 deaths2 deaths3 deaths4 deaths5 deaths6 deaths7 deaths8
		deaths21 deaths22 deaths23 deaths24 deaths25 deaths26 im_*;

* We have East Germany and West Germany 1979/1980-1990, and Germany 1990-1997 ;
*	drop east and west prior to 1990;
	drop if inlist(country,4090,4100);
* but note that estimates for "Germany" is apt to involve a lot of measurement error around reunification ;
	replace country_name="Germany" if country==4085 & country_name!="Germany";

save "`temp'",replace;

**ALL DEATHS ***;
/***************************
All deaths are captured in the cause code "B00"
***************************/
use "`temp'",clear;
	keep if cause=="B00";
	collapse (sum) deaths*, by(country country_name year sex);
	do dofiles\process_deaths.do;
gen icd=9;

save outfiles\alldeathsicd9.dta,replace;


**POISON**;
/*******************/
/*** poison ***/
	use "`temp'",clear;
	gen pois =0;
	replace pois=1 if inlist(cause,"B480","B560");
keep if pois==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 9;

save outfiles\poisonicd9.dta, replace;


/*******************/
/*** SUICIDE ***/
/***************/
use "`temp'",clear;
gen suicide = 0;
replace suicide=1 if cause=="B54";



keep if suicide==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 9;
save outfiles\suicideicd9.dta, replace;

/*******************/
/*** liver ***/
use "`temp'",clear;
gen liver = 0;
replace liver=1 if cause=="B347";

keep if liver==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 9;

save outfiles\livericd9.dta, replace;



/**********************/
/*** heart disease ***/

/**** this was the code we were using **************************************
use "`temp'",clear;
gen heart=0;
replace heart=1 if let_1=="B" & num_3>=25 & num_3 <=28 & length(cause)==3;
replace heart=1 if let_1=="B" & num_3>=250 & num_3<=289 & length(cause)==4;
keep if heart==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 9;

save outfiles\hearticd9.dta, replace;
**** this was the code we were using **************************************/

/*** heart disease ***/
use "`temp'",clear;
gen heart=0;
replace heart=1 if cause=="B25" ;
replace heart=1 if cause=="B26" ;
replace heart=1 if cause=="B27" ;
replace heart=1 if cause=="B28" ;
keep if heart==1;

collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 9;

save outfiles\hearticd9.dta, replace;

/*******************/
/*** cancer disease ***/

use "`temp'",clear;
gen cancer=0;
*pick up all of cancer;
replace cancer=1 if let_1=="B" & num_3>=8 & num_3 <=14 & length(cause)==3;


keep if cancer==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 9;

save outfiles\cancericd9.dta, replace;

/*******************/
/*** Lung cancer disease ***/
use "`temp'",clear;

gen lungC=0;
replace lungC=1 if cause=="B101";

keep if lungC==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd=9;

save outfiles\lungCicd9.dta, replace;

/*******************/
/*** Diabetes disease ***/
use "`temp'",clear;

gen diabetes=0;
replace diabetes=1 if cause=="B181";

keep if diabetes==1;

collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd=9;

save outfiles\diabetesicd9.dta, replace;

*log close;
