*cap log close
*cap drop _all
*set more off
# delimit ;
*cd "C:\mortality 04122016";

*log using dofiles\make_rates_5yr_race.log, replace;

tempfile tempmort0;

/* make a mortality count for both sexes combined */

use outfiles\mortcounts_5yr_race.dta;
reshape wide *mort, i(year race age_gp) j(sex);
foreach var in T P S L H C lungC D {;
gen `var'mort = `var'mort1 + `var'mort2 ;
};
keep year race age_gp Tmort-Dmort;
gen sex=0;
save `tempmort0';
append using outfiles\mortcounts_5yr_race ;
save `tempmort0' , replace;

use  infiles\Pop_race_5yr_1990_2014;
ren age age_gp ;
merge 1:1 year age_gp race sex using `tempmort0' ;

foreach var in T P S L H C lungC D {;
gen `var'rate = `var'mort*100000/Population;
};

keep year age_gp race sex *rate ;
save outfiles\rates_5yr_race, replace;

*log close; stop;

