*cap log close
*cap drop _all
*set more off
# delimit ;
*cd "C:\mortality 04122016";

*log using dofiles\makem_mortcounts_5yr_race.log, replace;

/* counting deaths to be parallel to the international data deaths */
/* and making mortality rates using c:\mort8913\data\cdc_5yr_race\pop_race_5yr_1990_2014.dta */

use outfiles\mort_8914 ;
gen one=1 ;
gen str1 xcode = icd10;

**ALL DEATHS ***;
bysort year age_gp race sex: egen Tmort = total(one);


/*******************/
/***** poison ******/
/*******************/

gen pois =0;
replace pois=1 if icd9n>=8500 & icd9n<=8589 ;
replace pois=1 if icd9n>=9800 & icd9n<=9899;
replace pois=1 if (icd9n>=850 & icd9n<=859 & length(icd9)==3)| (icd9n>=980 & icd9n<=989 & length(icd9)==3);


forval i = 10(1)15{;
	replace pois = 1 if icd10=="Y`i'" ;
};
forval i = 40(1)44{;
	replace pois = 1 if icd10=="X`i'" ;
};

bysort year age_gp race sex: egen Pmort = total(pois);



/*******************/
/***** SUICIDE ****/
/*****************/

gen suicide = 0;
replace suicide=1 if icd9n>=9500 & icd9n<=9599 ;
replace suicide= 1 if icd9n>=950& icd9n<=959 & length(icd9)==3;
forval i = 60(1)84{;
replace suicide = 1 if icd10=="X`i'" ;
};
replace suicide = 1 if icd10=="Y870";

bysort year age_gp race sex: egen Smort = total(suicide);


/*****************/
/*** LIVER    ***/
/***************/

gen liver = 0;
replace liver=1 if icd9n>=5710 & icd9n<=5719 ;


replace liver=1 if icd10=="K70";

forval i = 0(1)9{;
replace liver=1 if icd10=="K70`i'";
};

forval i = 30(1)49{;
replace liver=1 if icd10=="K7`i'";
};

bysort year age_gp race sex: egen Lmort = total(liver);

/***************************/
/*** heart disease ***/
/***************************/

gen heart =0;
replace heart=1 if icd9n>=390 & icd9n<=429 & length(icd9)==3;
replace heart=1 if icd9n>=3900 & icd9n<=4299;
gen num=substr(icd10,2,3);
destring num, replace;
xx;
replace heart =1 if substr(icd10,1,1)=="I" & num>=10 & num<=99 & length(icd10)==4;
replace heart=1 if ((inlist(num,0,11,13) & length(icd10)==3)|((num>=20& num<=51) & length(icd10)==3)) & xcode=="I";
replace heart=1 if (num>=200& num<=519 & length(icd10)==4)& xcode=="I";
replace heart=1 if inlist(substr(icd10,1,3),"I11","I13");

bysort year age_gp race sex: egen Hmort = total(heart);


/**********************/
/*** cancer - all   ***/
/**********************/

gen cancer=0;
replace cancer =1 if icd9n>=140 & icd9n<=208 & length(icd9)==3;
replace cancer =1 if icd9n>=1400 & icd9n<=2089;
replace cancer =1 if xcode=="C";
bysort year age_gp race sex: egen Cmort = total(cancer);


/********************/
/*** Lung cancer  ***/
/********************/

gen lungC=0;
replace lungC=1 if icd9n>=1620 & icd9n<=1629 ;

replace lungC=1 if substr(icd10,1,3)=="C34";
bysort year age_gp race sex: egen lungCmort = total(lungC);


/************************/
/*** Diabetes disease ***/
/************************/

gen diabetes=0;
replace diabetes=1 if icd9n>=2500 & icd9n<=2509 ;
forval i = 100(1)149{;
replace diabetes=1 if icd10=="E`i'";
};

bysort year age_gp race sex: egen Dmort = total(diabetes);

bysort year age_gp race sex: keep if _n==1;
keep year age_gp race sex *mort;
drop if race==.;
save outfiles\mortcounts_5yr_race.dta, replace;

