cap log close
cap drop _all
set more off

log using make_intl_rates_5yr.log, replace
# delimit ;

/* combining rates from different COD into one file by sex and 5yr age group */
tempfile temprate;

cd ..\finalfiles9_10\rates;
use alldeathsicd9_10_pop.dta_iso.dta ;
 ren rate_ Trate;
save `temprate', replace;

use hearticd9_10_pop.dta_iso.dta ;
 ren rate_ Hrate;
merge 1:1 year isocode age sex using `temprate';
drop _m;
save `temprate', replace;

use cancericd9_10_pop.dta_iso.dta ;
ren rate_ Crate;
merge 1:1 year isocode age sex using `temprate';
drop _m;
save `temprate', replace;


use diabetesicd9_10_pop.dta_iso.dta;
ren rate_ Drate;
merge 1:1 year isocode age sex using `temprate';
drop _m;
save `temprate', replace;


use livericd9_10_pop.dta_iso.dta ;
ren rate_ Lrate;
merge 1:1 year isocode age sex using `temprate';
drop _m;
save `temprate', replace;

use lungCicd9_10_pop.dta_iso.dta ;
ren rate_ lungCrate;
merge 1:1 year isocode age sex using `temprate';
drop _m;
save `temprate', replace;


use poisonicd9_10_pop.dta_iso.dta ;
ren rate_ Prate;
merge 1:1 year isocode age sex using `temprate';
drop _m;
save `temprate', replace;

use suicideicd9_10_pop.dta_iso.dta ;
ren rate_ Srate;
merge 1:1 year isocode age sex using `temprate';
drop _m;
save `temprate', replace;

gen PSLrate = Prate+Srate+Lrate;
/* PRT missing vals for 2004 and 2005 */
drop if iso=="PRT" & year>=2004 & year<=2005 ;

save  intl_rates_5yr.dta, replace;

use "c:\users\accase\dropbox\mortality by cause by country by year\USA Mortality\outfiles\rates_5yr_race.dta" ;
ren age_gp age;
gen isocode = "USW" if race==1;
replace isocode = "USB" if race==2;
replace isocode = "USH" if race==3;
drop race;
drop if year==1989;
gen PSLrate = Prate+Srate+Lrate;
merge 1:1 isocode year age sex using intl_rates_5yr;
drop _m;

save  intl_rates_5yr.dta, replace;

/**************************************************/
/* the following can add extra countries as you go
/* adding Scotland */

use "c:\users\accase\dropbox\HMD\data\SCO\SCO_rates_5yr.dta" ;
ren age_gp age;
gen isocode = "SCO" ;
gen PSLrate = Prate+Srate+Lrate;
merge 1:1 isocode year age sex using intl_rates_5yr;
drop _m;

save  intl_rates_5yr_update.dta, replace;
*********************************************/
/*********************************************/
log close;
