cap log close
cap drop _all
set more off
# delimit ;
log using c:\users\accase\dropbox\coumas\mort\dofiles\make_couma00_couma10_WNHrates_4554.log  , replace;

/* Couma-level mortality rates for WNH 45-54 */
/* Mortality rates are calculated using death certificates with county identifiers from mort_8915.dta.
   These are merged with county population data from CDC bridged-race estimates WNH both sex ages 45-54   */
* population numbers are in c:\users\accase\dropbox\USCounties\population\bridge_pop\WNH_4554_pop_cty_0014 ;

tempfile tempdat;



/********* PART I. *****************************************************/
/* take population counts for WNH 4554 by county and merge with coumas */
/****************** ****************************************************/

use c:\users\accase\dropbox\USCounties\population\bridge_pop\WNH_4554_pop_cty_0014 ;
list notes if notes!="";
drop notes;

ren yearlyjuly1stestimates year ;
drop yearly;
ren county CountyName ;
ren countycode county ;

*we are going to merge with the 2000 coumas (2000-2011) first so drop the later years;
keep if year<=2011;


merge m:1 county  using c:\users\accase\dropbox\brookings\archive\USMortalityData\dofiles\couma00_county ;
/* drop DC and Alaska  */
drop if county>=11001 & county<12000;
drop if county>=2000  & county<3000;
drop if _m!=3;

drop _m;
isid year county;
save `tempdat';


use c:\users\accase\dropbox\USCounties\population\bridge_pop\WNH_4554_pop_cty_0014 ;

ren yearlyjuly1stestimates year ;
drop yearly;
ren county CountyName ;
ren countycode county ;

*we are going to merge with the 2010 coumas (2012-2014) so drop earlier years;
keep if year>=2012 & year<=2014;


merge m:1 county  using c:\users\accase\dropbox\brookings\archive\USMortalityData\dofiles\couma10_county ;
/* drop DC and Alaska  */
drop if county>=11001 & county<12000;
drop if county>=2000  & county<3000;
drop if _m!=3;  drop _m;

isid year county;
merge 1:1 year county using `tempdat';
drop _m;
ren county county_code;
drop if year<2000;
save `tempdat' , replace;


/********* PART II. *****************************************/
/* getting mortality count data to use with population data */
/****************** *****************************************/

use "c:\aamortality102716\outfiles\mort_8915";
/**  keep white non-Hispanics ages 45-54  2000-2014  ****/
keep if year>=2000 & year<=2014;
keep if ind_WNH==1;

* drop DC and Alaska  *;
drop if (fipsstr==11|fipsstr==2) ;

keep if age>=45 & age<=54;

keep  icd9 icd9n icd10 year   fipsstr fipscty;
gen str1 xcode = icd10 ;

/* make our cause of death indicators */

/*******************/
/*** poison ***/

gen pois = 0;

/* the icd9 selection here has been changed to add alcohol to poisoning, and remove things from intent undetermined */
replace pois=1 if icd9n>=8500 & icd9n<=8609 ;
replace pois=1 if icd9n>=9800 & icd9n<=9804;
replace pois=1 if (icd9n>=850 & icd9n<=860 & length(icd9)==3)| (icd9n==980  & length(icd9)==3);

forval i = 10(1)15{;
replace pois = 1 if icd10=="Y`i'" ;
};
forval i = 40(1)45{;
replace pois = 1 if icd10=="X`i'" ;
};
forval i = 45(2)49{;
replace pois = 1 if icd10=="Y`i'" ;
};


/*******************/
/*** suicide ***/

gen suicide = 0;

replace suicide=1 if icd9n>=9500 & icd9n<=9599 ;
replace suicide= 1 if icd9n>=950 & icd9n<=959 & length(icd9)==3;

forval i = 60(1)84{;
replace suicide = 1 if icd10=="X`i'" ;
};
replace suicide = 1 if icd10=="Y870";

/*******************/
/*** liver ***/
gen liver = 0;

replace liver=1 if icd9n>=5710 & icd9n<=5719 ;
replace liver=1 if icd10=="K70";

forval i = 0(1)9{;
replace liver=1 if icd10=="K70`i'";
};

forval i = 30(1)49{;
replace liver=1 if icd10=="K7`i'";
};

/*******************/



gen county_code = fipsstr*1000+fipscty ;

gen one=1;
bysort  county_code year: egen Tmort_cty  = total(one);
bysort  county_code year: egen Pmort_cty  = total(pois);
bysort  county_code year: egen Smort_cty  = total(suicide);
bysort  county_code year: egen Lmort_cty  = total(liver);
drop one;

gen PSLmort_cty = Pmort_cty + Smort_cty + Lmort_cty;

by county_code year, sort: keep if _n==1;



/********* PART III. *****************************************/
/* creating mortality rates by couma for Trate and PSL      */
/****************** *****************************************/


merge 1:1 year county_code using `tempdat' ;

tab county if _m!=3;
/* we need to come back to these */

drop if _m!=3;
drop _m;

/* sum deaths and pop by couma - NB: identification requires state and couma */

bysort year state couma: egen PSLmort_couma = total(PSLmort_cty);
bysort year state couma: egen Tmort_couma = total(Tmort_cty);

bysort year state couma: egen TPop_couma =  total(population);

bysort year state couma: keep if _n==1;
keep year state couma *_couma ;
gen PSLrate_couma = PSLmort_couma*100000/TPop_couma ;
gen Trate_couma = Tmort_couma*100000/TPop_couma;

label var PSLmort_couma "PSL deaths by state couma";
label var Tmort_couma "all deaths by state couma";

label var PSLrate_couma "PSL rate by state couma";
label var Trate_couma "all-cause mortality rate by state couma";

/* check against CDC Wonder  all-cause 2011=414.4, 2012=410.9, 2013=415.4, 2014=417.8*/
forval i = 2011(1)2014 {;
dis `i';
sum Trate_couma if year==`i' [aw=TPop];
};
/* our means are 0.8 per 100,000 higher than CDC Wonder, but Alaska (missing here) had lower mortality rates in 2011-2013 */

save c:\users\accase\dropbox\coumas\mort\data\couma00_couma10_WNHrates_4554.dta, replace ;
log close; stop;
