cap log close
cap drop _all
set more off

log using "c:\users\accase\dropbox\brookings\archive\tables\table2.log", replace
# delimit ;

/* updating the USW USB and USH numbers here */

tempfile tempUS;

use c:\users\accase\dropbox\acs\data\cdc_9915_5yr_sex\data\wnh_bnh_5yr_sex.dta;
 keep if sex==0;
 gen PSLrate = Prate + Srate + Lrate;
 keep year race age_gp sex Trate Hrate Crate PSLrate;
ren age_gp age;

gen str3 isocode = "USW" if race==1;
replace isocode = "USB" if race==2;
replace isocode = "USH" if race==3;
drop race;
save `tempUS';

use "c:\users\accase\dropbox\mortality by cause by country by year\finalfiles9_10_update\rates\intl_rates_5yr.dta";
 keep if year>=1999;
 keep if sex==0;
 drop if iso=="USW"|iso=="USB"|iso=="USH" ;
merge 1:1 year iso age sex using `tempUS';
/* NB - we merge back in fewer US obs than we dropped because intl data included ages 20-24 and 70-74 */

gen lnT = log(Trate);
gen lnH = log(Hrate);
gen lnC = log(Crate);
gen lnPSL = log(PSLrate);


foreach COD in T H C PSL {;
foreach var in USW USB USH  UK IRL CAN AUS FRA GER SWE CHE DNK NLD ESP ITA JPN {;
dis "`var' `COD'";
reg ln`COD'  year if iso=="`var'" & age==50 ;
};
};

log close; stop;

