*process variables;
	#delimit ;
	
	if srvy_yr<= 2015 & srvy_yr>= 2004 {;
		*There is a simple and a detailed version of occupation and industry throughout the years;
		*the simple version identifies around 20 categories of occupation or industry type, and the detailed version itemizes these occupations or industries;
		/*FROM THE NHIS: Regarding the occupation recodes, there are going to be 3 big disconnects in the data, which the data requestor has spelled out
		in her table  one pertains to a change in universe (in 2001 and after) and one pertains to a change in recodes (in 2004), with the latter
		being more analytically problematic.
		OCCUP1 and OCCUP2 were the public use recodes in 1997-2004 (with an expanded universe in 2001), and OCCUPN1 and OCCUPN2 were the public use
		recodes in 2004-present (same expanded universe).     Survey year 2004 is very important: it is the only year that both the old (OCCUP1/OCCUP2)
		and new (OCCUPN1/OCCUPN2) occupation recodes are included on the public use file.
		To answer her specific questions, OCCUPN1 and OCCUPN2 are compatible across 2004 to the present (including the 2014 data that will be released in
		June) even though the 4-digit codes that we received from Census changed in 2010.  While there were some new 4-digit codes in 2010, they still
		mapped to the same occupational groups so there was no need to add new categories to the public use recodes.  Thus, OCCUPN1 and OCCUPN2 have
		remained unchanged since 2004.   And regarding OCCUP1 and OCCUP1A, she is correct: these variables have the same categories and differ only in
		their universes (OCCUP1A has the expanded current + ever employed universe).  see email april 15, 2014
		*occup1a does not exist for these years: 1997-2000 so we can only offer current occupation (or current industry)
		*
		* Using the 2004 sample adult dataset which has both occup1a occupn2, I have created a crosswalk between occup1a and occupn2 (detailed old occupation category to simple
		new occupation category. I use this  crosswalk to convert occupation codes from 2003 to 1997 to the current (2004 to now)  occupation codes (and iindustry codes)
		
		* There is information for occupation currently held and occupation held previously (if not currently working) to as far back
		* as 2001. 2000 and earlier just has current occupation.
		For INDUSTRY, it is roughly the same story: indstrn1 indstrn2 were the public use recodes in 2004-present
		* indstr1a and indstr2a were between 2001 and 2004 and indstry1 and indstry2 for 2000 and earlier
		
		*I have created a crosswalk between indstr1a and indstrn2. I use this crosswalk to convert industry codes from 2003 to 1997 to the modern day
		* industry code.
		METHOD: for 2004 through 2014, it is straightforward. I create a variable called occupation and populate it with the values from occupn2 (simple version of occupation)
			          Then I create two variables based on the following: if the person is currently working, the occ_now is equal to occupation. If the person is not currently working
			          but has worked historically, then occ_prev is set equal to occupation. Then I drop occupation
			          For pre-2004, I have created a crosswalk that sets the earlier detailed occupation codes equal to the current simple occupation codes.
			          	I create a variable occupation that is set equal to the new simple occupation codes based on the earlier detailed codes. Then I
			          	create occ_now and occ_prev as before. there is no occ_prev for the years 2000 and earlier
			          Industry is handled in a virtually identical way.
		*/
		*OCCUPATION;
		*we are going to use the simple occupation categories which haved 23 possible values;
			gen occupation=occupn2;
			replace occupation=. if occupation>90 & occupation!=.;
		* create a variable for the occupation currently held;
			gen occ_now=occupation if wrklyr==0;
		* create a variable for previously held occupations;
			gen occ_prev =occupation if wrkly!=0 & occupation!=.;
		drop occupation;
		*INDUSTRY;
		
		gen industry = indstrn2;
		replace industry=. if industry>90 & industry!=.;
		*create a variable for the industry currently in;
			gen ind_now =industry if wrklyr==0;
		*create a variable for industry previously in;
			gen ind_prev= industry if wrklyr !=0 & industry!=.;
		drop industry;
		
	*education;
		rename educ1 educ;
		
	};
	

	if srvy_yr< 2004  & srvy_yr>= 2001{;
	
		* we have created a crosswalk from the old detailed categories to the new summary categories for both
			  occupation and industry;
			*we are going to use the simple occupation categories which has 23 possible values;
	 *OCCUPATION:;
		
		*we are going to use the simple occupation categories which has 23 possible values;
			gen occupation=.;
			replace occupation = 1 if occup1a==1;
			replace occupation = 1 if occup1a==2;
			replace occupation = 2 if occup1a==3;
			replace occupation = 4 if occup1a==4;
			replace occupation = 4 if occup1a==5;
			replace occupation = 3 if occup1a==6;
			replace occupation = 10 if occup1a==7;
			replace occupation = 10  if occup1a==8;
			replace occupation = 8 if occup1a==9;
			replace occupation = 9 if occup1a==10;
			replace occupation = 6 if occup1a==11;
			replace occupation = 11 if occup1a==12;
			replace occupation = 3 if occup1a==13;
			replace occupation = 16 if occup1a==14;
			replace occupation = 16 if occup1a==15;
			replace occupation = 16 if occup1a==16;
			replace occupation = 17 if occup1a==17;
			replace occupation = 17  if occup1a==18;
			replace occupation = 17  if occup1a==19;
			replace occupation = 17  if occup1a==20;
			replace occupation = 17 if occup1a==21;
			replace occupation = 14 if occup1a==22;
			replace occupation = 12 if occup1a==23;
			replace occupation = 12 if occup1a==24;
			replace occupation = 13 if occup1a==25;
			replace occupation = 11 if occup1a==26;
			replace occupation = 14 if occup1a==27;
			replace occupation = 15 if occup1a==28;
			replace occupation = 1 if occup1a==29;
			replace occupation = 18 if occup1a==30;
			replace occupation = 18 if occup1a==31;
			replace occupation = 20 if occup1a==32;
			replace occupation = 19 if occup1a==33;
			replace occupation = 21 if occup1a==34;
			replace occupation = 21 if occup1a==35;
			replace occupation = 21 if occup1a==36;
			replace occupation = 22 if occup1a==37;
			replace occupation = 22 if occup1a==38;
			replace occupation = 22 if occup1a==39;
			replace occupation = 19 if occup1a==40;
			replace occupation = 22  if occup1a==41;
			replace occupation = 23 if occup1a==50;
			
			* create a variable for the occupation currently held;
					gen occ_now=occupation if wrklyr==0;
			* create a variable for previously held occupations;
					gen occ_prev =occupation if wrkly!=0 & occupation!=.;
		drop occupation;
		
		*INDUSTRY:;
		gen industry=.;
		replace industry=	1	if indstr1a==	1	;
		replace industry=	1	if indstr1a==	2	;
		replace industry=	2	if indstr1a==	10	;
		replace industry=	4	if indstr1a==	20	;
		replace industry=	5	if indstr1a==	30	;
		replace industry=	5	if indstr1a==	31	;
		replace industry=	9	if indstr1a==	32	;
		replace industry=	5	if indstr1a==	33	;
		replace industry=	5	if indstr1a==	34	;
		replace industry=	5	if indstr1a==	40	;
		replace industry=	5	if indstr1a==	41	;
		replace industry=	5	if indstr1a==	42	;
		replace industry=	5	if indstr1a==	43	;
		replace industry=	5	if indstr1a==	44	;
		replace industry=	5	if indstr1a==	45	;
		replace industry=	5	if indstr1a==	46	;
		replace industry=	8	if indstr1a==	50	;
		replace industry=	8	if indstr1a==	51	;
		replace industry=	8	if indstr1a==	52	;
		replace industry=	9	if indstr1a==	53	;
		replace industry=	3	if indstr1a==	54	;
		replace industry=	6	if indstr1a==	60	;
		replace industry=	7	if indstr1a==	61	;
		replace industry=	7	if indstr1a==	62	;
		replace industry=	7	if indstr1a==	63	;
		replace industry=	18	if indstr1a==	64	;
		replace industry=	7	if indstr1a==	65	;
		replace industry=	10	if indstr1a==	70	;
		replace industry=	10	if indstr1a==	71	;
		replace industry=	14	if indstr1a==	75	;
		replace industry=	19	if indstr1a==	76	;
		replace industry=	19	if indstr1a==	77	;
		replace industry=	19	if indstr1a==	78	;
		replace industry=	17	if indstr1a==	79	;
		replace industry=	16	if indstr1a==	80	;
		replace industry=	16	if indstr1a==	81	;
		replace industry=	15	if indstr1a==	82	;
		replace industry=	15	if indstr1a==	83	;
		replace industry=	16	if indstr1a==	84	;
		replace industry=	12	if indstr1a==	85	;
		replace industry=	20	if indstr1a==	90	;
		replace industry=	21	if indstr1a==	93	;
		
	* create a variable for the industry currently in;
		gen ind_now=industry if wrklyr==0;
	* create a variable for industry previously in;
		gen ind_prev =industry if wrkly!=0 & industry!=.;
		drop industry;
		
	};
	if srvy_yr< 2001 {;
	* we have created a crosswalk from the old detailed categories to the new summary categories for both
	  occupation and industry;
	*we are going to use the simple occupation categories which has 23 possible values;
	 *OCCUPATION:;
				gen occupation=.;
				replace occupation = 1 if occup1==1;
				replace occupation = 1 if occup1==2;
				replace occupation = 2 if occup1==3;
				replace occupation = 4 if occup1==4;
				replace occupation = 4 if occup1==5;
				replace occupation = 3 if occup1==6;
				replace occupation = 10 if occup1==7;
				replace occupation = 10  if occup1==8;
				replace occupation = 8 if occup1==9;
				replace occupation = 9 if occup1==10;
				replace occupation = 6 if occup1==11;
				replace occupation = 11 if occup1==12;
				replace occupation = 3 if occup1==13;
				replace occupation = 16 if occup1==14;
				replace occupation = 16 if occup1==15;
				replace occupation = 16 if occup1==16;
				replace occupation = 17 if occup1==17;
				replace occupation = 17  if occup1==18;
				replace occupation = 17  if occup1==19;
				replace occupation = 17  if occup1==20;
				replace occupation = 17 if occup1==21;
				replace occupation = 14 if occup1==22;
				replace occupation = 12 if occup1==23;
				replace occupation = 12 if occup1==24;
				replace occupation = 13 if occup1==25;
				replace occupation = 11 if occup1==26;
				replace occupation = 14 if occup1==27;
				replace occupation = 15 if occup1==28;
				replace occupation = 1 if occup1==29;
				replace occupation = 18 if occup1==30;
				replace occupation = 18 if occup1==31;
				replace occupation = 20 if occup1==32;
				replace occupation = 19 if occup1==33;
				replace occupation = 21 if occup1==34;
				replace occupation = 21 if occup1==35;
				replace occupation = 21 if occup1==36;
				replace occupation = 22 if occup1==37;
				replace occupation = 22 if occup1==38;
				replace occupation = 22 if occup1==39;
				replace occupation = 19 if occup1==40;
				replace occupation = 22  if occup1==41;
				replace occupation = 23 if occup1==50;
				
				* create a variable for the occupation currently held;
						gen occ_now=occupation;
						drop occupation;
				*INDUSTRY:;
					gen industry=.;
					replace industry=	1	if indstry1==	1	;
					replace industry=	1	if indstry1==	2	;
					replace industry=	2	if indstry1==	10	;
					replace industry=	4	if indstry1==	20	;
					replace industry=	5	if indstry1==	30	;
					replace industry=	5	if indstry1==	31	;
					replace industry=	9	if indstry1==	32	;
					replace industry=	5	if indstry1==	33	;
					replace industry=	5	if indstry1==	34	;
					replace industry=	5	if indstry1==	40	;
					replace industry=	5	if indstry1==	41	;
					replace industry=	5	if indstry1==	42	;
					replace industry=	5	if indstry1==	43	;
					replace industry=	5	if indstry1==	44	;
					replace industry=	5	if indstry1==	45	;
					replace industry=	5	if indstry1==	46	;
					replace industry=	8	if indstry1==	50	;
					replace industry=	8	if indstry1==	51	;
					replace industry=	8	if indstry1==	52	;
					replace industry=	9	if indstry1==	53	;
					replace industry=	3	if indstry1==	54	;
					replace industry=	6	if indstry1==	60	;
					replace industry=	7	if indstry1==	61	;
					replace industry=	7	if indstry1==	62	;
					replace industry=	7	if indstry1==	63	;
					replace industry=	18	if indstry1==	64	;
					replace industry=	7	if indstry1==	65	;
					replace industry=	10	if indstry1==	70	;
					replace industry=	10	if indstry1==	71	;
					replace industry=	14	if indstry1==	75	;
					replace industry=	19	if indstry1==	76	;
					replace industry=	19	if indstry1==	77	;
					replace industry=	19	if indstry1==	78	;
					replace industry=	17	if indstry1==	79	;
					replace industry=	16	if indstry1==	80	;
					replace industry=	16	if indstry1==	81	;
					replace industry=	15	if indstry1==	82	;
					replace industry=	15	if indstry1==	83	;
					replace industry=	16	if indstry1==	84	;
					replace industry=	12	if indstry1==	85	;
					replace industry=	20	if indstry1==	90	;
					replace industry=	21	if indstry1==	93	;
					
				* create a variable for the industry currently in;
					gen ind_now=industry if wrklyr==0;
						
		drop industry;
		
		};
		
		
*****WORK VARIABLES*************;
*create work variables;
	*currently working?;
		gen workcur=wrklyr==0;
	
		replace workcur =. if inlist(wrklyr,7,8,9);
		
	* create retired variable;		
	*different years have different variables for retired;
	
		if srvy_yr<=2015 & srvy_yr>= 1999 {;
			gen retired=whynowk==3;
			replace retired =. if whynowk>95 & whynowk!=.;
			replace retired=. if workcur==. & whynowk==.;
			

		};
		if srvy_yr<=1998 & srvy_yr>= 1997 {;
			gen retired=whynowrk==3;
			replace retired =. if whynowrk>7 & whynowrk!=.;
			replace retired=. if workcur==. & whynowrk==.;

		};

	*ever worked in your life?;
		if srvy_yr<=2015 & srvy_yr>= 2001 {;
			gen workever=wrkly==0 |everwrk==1;
			replace workever=. if inlist(everwrk,7,8,9);
			replace workever=. if inlist(wrkly,7,8,9);
			
	};
	*disabled?;
	
			if srvy_yr<=2015 & srvy_yr>= 2004 {;
				gen disabled=whynowk==9;
				replace disabled =. if whynowk>95 & whynowk!=.;
				replace disabled=. if workcur==. & whynowk==.;
			};
			if srvy_yr<=2003 & srvy_yr>= 2001 {;
				gen disabled=whynowk==8;
				replace disabled =. if whynowk>95 & whynowk!=.;
				replace disabled=. if workcur==. & whynowk==.;
	
			};
				if srvy_yr<=2000 & srvy_yr>= 1999 {;
							gen disabled=whynowk==6;
							replace disabled =. if whynowk>95 & whynowk!=.;
							replace disabled=. if workcur==. & whynowk==.;

			};
	*YEARS WORKED;
		if srvy_yr<=2000{;
			gen yrswrkcur=yrswrk_p;
		};
		if srvy_yr >2000 {;
			gen yrswrkcur=	yrswrkpa if ( inlist(doinglw,1,2,4) & everwrk!=1);
			gen yrswrkprev=yrswrkpa if everwrk==1;
		};
	*variable regarding mentally challenged changes names;
	if srvy_yr<=2010{;
		rename aflhca14 alhca14a;
	};
	*age;
	  	rename age_p age;
	  	
	
	*asi variables added in 2013;
	if srvy_yr>=2013{;
		foreach var of varlist asi* {;
			replace `var'=. if inlist(`var',7,8,9);
			tab `var',m;
		};
	};
	*renamed alc5 variables for some reason starting in 2014;
	if srvy_yr>=2014{;
		rename alc5upn1 alc5upno;
		rename alc5upt1 alc5uptp;
		rename alc5upy1 alc5upyr;
	};
		
	
			

	
	

	
	
