cap log close
cap drop _all
set more off
# delimit ;
log using graph_fig3_1.log , replace ;


/* creating variables from March CPS 1980-2016 */
/* to graph "not in labor force" by birth year and age */


/****************/

/* Figure 3.1 */
use c:\users\accase\dropbox\cepr_march\data\cps_march_inc_8016.dta ;
gen yob = year-age ;

keep if yob>=1930 & yob<=1981 ;

gen YOB = 1930 if yob>=1930 & yob<=1931;

forval i = 1940(10) 1980 {;
replace YOB = `i' if yob>=`i' & yob<=`i'+1;
};


keep if YOB!=.;
keep if age>=25 & age<=59 ;

/* WNH MEN */
keep if wbho==1;
keep if female==0;

gen EDCL=1 if edclass>=1 & edclass<=2;
replace EDCL=3 if edclass==3 ;


tab YOB if EDC==1, sum(nilf);
tab YOB if EDC==3, sum(nilf);

forval i = 1930(10)1980 {;
dis "EDC 1 YOB `i'";
sum age if EDC==1 & YOB==`i';

dis "EDC 3 YOB `i'";
sum age if EDC==3 & YOB==`i';
};

collapse nilf [aw=wgt], by(YOB age EDCL);

gen pct_nilf = nilf*100;  ;
ren YOB yob;


gr two (line pct_nilf age if yob==1930  & EDC==1  , lcolor(magenta) lwidth(thick) lpattern(longdash_shortdash))
       (line pct_nilf age if yob==1940  & EDC==1  , lcolor(blue) lwidth(thick))
       (line pct_nilf age if yob==1950  & EDC==1  , lwidth(thick)  lpattern(longdash))
       (line pct_nilf age if yob==1960  & EDC==1  , lcolor(midgreen) lwidth(thick))
       (line pct_nilf age if yob==1970  & EDC==1  , lcolor(orange) lwidth(thick) lpattern(longdash))
       (line pct_nilf age if yob==1980  & EDC==1  , lwidth(thick) lcolor(red)),
  xlabel(25 35 45 55)
  graphregion(color(white)) legend(off) title(less than BA) ytitle(percent not in labor force)
  saving(c:\users\accase\dropbox\brookings\results\fig3_1A.gph, replace);


gr two (line pct_nilf age if yob==1930  & EDC==3  , lcolor(magenta) lwidth(thick) lpattern(longdash_shortdash))
       (line pct_nilf age if yob==1940  & EDC==3  , lcolor(blue) lwidth(thick))
       (line pct_nilf age if yob==1950  & EDC==3  , lwidth(thick)  lpattern(longdash))
       (line pct_nilf age if yob==1960  & EDC==3  , lcolor(midgreen) lwidth(thick))
       (line pct_nilf age if yob==1970  & EDC==3  , lcolor(orange) lwidth(thick) lpattern(longdash))
       (line pct_nilf age if yob==1980  & EDC==3  , lwidth(thick) lcolor(red)),
  xlabel(25 35 45 55)  ylabel(10 20 30)
  graphregion(color(white)) legend(off) title(BA or more) ytitle(percent not in labor force)
  saving(c:\users\accase\dropbox\brookings\results\fig3_1B.gph, replace);


/****************/

/* appendix figure on nilf for all education groups combined */
use c:\users\accase\dropbox\cepr_march\data\cps_march_inc_8016.dta, clear ;

gen yob = year-age ;
keep if yob>=1930 & yob<=1981 ;
keep if age>=25 & age<=59 ;

/* WNH MEN */
keep if wbho==1;
keep if female==0;

gen YOB = 1930 if yob>=1930 & yob<=1931;

forval i = 1940(10) 1980 {;
replace YOB = `i' if yob>=`i' & yob<=`i'+1;
};


keep if YOB!=.;


collapse nilf [aw=wgt], by(YOB age );

gen pct_nilf = nilf*100 ;


gr two (line pct_nilf age if YOB==1930    , lcolor(magenta) lwidth(thick) lpattern(longdash_shortdash))
       (line pct_nilf age if YOB==1940    , lcolor(blue) lwidth(thick))
       (line pct_nilf age if YOB==1950    , lwidth(thick)  lpattern(longdash))
       (line pct_nilf age if YOB==1960    , lcolor(midgreen) lwidth(thick))
       (line pct_nilf age if YOB==1970    , lcolor(orange) lwidth(thick) lpattern(longdash))
       (line pct_nilf age if YOB==1980    , lwidth(thick) lcolor(red)),
  xlabel(25 35 45 55)  ylabel(0 10 20 30 )
  graphregion(color(white)) legend(off) title("Percent not in the labor force, white non-Hispanic men, all education groups", color(black) size(medsmall))
  ytitle(percent not in labor force)
  saving(c:\users\accase\dropbox\brookings\results\yob_nilf_wnh_M_ALLed_1930_1981.gph, replace);


log close ; stop;
