cap log close
cap drop _all
set more off
# delimit ;
log using c:\users\accase\dropbox\brookings\archive\dofiles\graph_fig1_12.log  , replace;
use c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta;

keep if age>=30 & age<=74;

forval i = 1(1)3 {;
dis "edclass `i'";
sum ind_EVG if year>=1993 & year<=1996 & edclass==`i' ;
sum ind_EVG if year>=1999 & year<=2002 & edclass==`i' ;
sum ind_EVG if year>=2005 & year<=2008 & edclass==`i' ;
sum ind_EVG if year>=2012 & year<=2015 & edclass==`i' ;
};

gr two  (lpoly ind_EVG age if year>=1993 & year<=1996 & edclass==1 [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=1999 & year<=2002 & edclass==1 [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=2005 & year<=2008 & edclass==1 [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=2012 & year<=2015 & edclass==1 [aw=A_F], lwidth(medthick)),
        ylabel(.3 .4 .5 .6 .7 .8) legend(off) graphregion(color(white))
        ytitle(fraction) xtitle(age) title("high school or less", color(black) size(medlarge))
        saving(c:\users\accase\dropbox\brfss\results\EVG_ed1_3074_9315.gph, replace);

gr two  (lpoly ind_EVG age if year>=1993 & year<=1996 & edclass==2 [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=1999 & year<=2002 & edclass==2 [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=2005 & year<=2008 & edclass==2 [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=2012 & year<=2015 & edclass==2 [aw=A_F], lwidth(medthick)),
        ylabel(.3 .4 .5 .6 .7 .8)
        legend(off) graphregion(color(white)) ytitle(fraction) xtitle(age) title("some college", color(black) size(medlarge))
        saving(c:\users\accase\dropbox\brfss\results\EVG_ed2_3074_9315.gph, replace);


gr two  (lpoly ind_EVG age if year>=1993 & year<=1996 & edclass==3 [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=1999 & year<=2002 & edclass==3 [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=2005 & year<=2008 & edclass==3 [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=2012 & year<=2015 & edclass==3 [aw=A_F], lwidth(medthick)),
        ylabel(.3 .4 .5 .6 .7 .8)
        legend(off) graphregion(color(white)) ytitle(fraction) xtitle(age) title("BA or more", color(black) size(medlarge))
        saving(c:\users\accase\dropbox\brfss\results\EVG_ed3_3074_9315.gph, replace);


gr two  (lpoly ind_EVG age if year>=1993 & year<=1996  [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=1999 & year<=2002  [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=2005 & year<=2008  [aw=A_F], lwidth(medthick))
        (lpoly ind_EVG age if year>=2012 & year<=2015  [aw=A_F], lwidth(medthick)),
        ylabel(.3 .4 .5 .6 .7 .8)
        legend(off) graphregion(color(white)) ytitle(fraction) xtitle(age) title("ALL", color(black) size(medlarge))
        saving(c:\users\accase\dropbox\brfss\results\EVG_edALL_3074_9315.gph, replace);

cd c:\users\accase\dropbox\brfss\results ;
graph combine EVG_ed1_3074_9315.gph EVG_ed2_3074_9315.gph EVG_ed3_3074_9315.gph EVG_edALL_3074_9315.gph ;

log close; stop;

