cap log close
cap drop _all
set more off
# delimit ;
log using c:\aamortality102716\dofiles\graph_change_mort_byed.log, replace;
/* counting mortality by cause and all-cause for non-Hispanic whites 1990-2014 by 5-yr age group by sex and education class */
/* EXCLUDING FOUR STATES THAT DON'T HAVE EDUCATION DATA IN EARLY 1990S ON DEATH CERTS: GA,OK,RI,SD */
/* for education work: don't use data prior to 1992 */
/* we have pop counts for 5-yr sex groups from March CPS  */


use c:\aamortality102716\outfiles\WNHrates_sex_5yr_state_ed_9215;
isid year age sex edclass;
bysort year age sex: egen Tpop_yas = total(TPop);
bysort year age sex: egen Tmort_yas = total(Tmort);
gen TRate_yas = Tmort_yas*100000/Tpop_yas ;

keep year age sex edclass Trate TRate_yas ;
keep if year==1998|year==2015;
drop if age>=65;
sort age sex edclass year;
by age sex edclass: gen TEDiff = Trate-Trate[_n-1];
sort age sex edclass year;
by age sex edclass: gen T0Diff = TRate_yas-TRate_yas[_n-1];
/* NB: TRate_yas is NOT edclass specific: it's the Trate over all edclasses */



*gr two (line TEDiff age if sex==1 & edclass==3, lwidth(thick) lpattern(longdash))
       (line TEDiff age if sex==1 & edclass==2, lwidth(thick) lpattern(longdash))
       (line TEDiff age if sex==1 & edclass==1, lwidth(thick) lpattern(longdash))
       (line T0Diff age if sex==1 & edclass==1, lcolor(red) lwidth(thick)),
legend(off) yline(0) graphregion(color(white)) ytitle(change in mortality rate)
xlabel(25 30 35 40 45 50 55 60)
xtitle(five-year age group) ysize(3.2) xsize(3.8) ylabel(-400 -200 0 200 400) title(Men);
*saving(c:\aamortality102716\edresults\change_mort_byed_9815_M.gph, replace);

gr two (line TEDiff age if sex==2 & edclass==3, lwidth(thick) lpattern(longdash))
       (line TEDiff age if sex==2 & edclass==2, lwidth(thick) lpattern(longdash))
       (line TEDiff age if sex==2 & edclass==1, lwidth(thick) lpattern(longdash))
       (line T0Diff age if sex==2 & edclass==1, lcolor(red) lwidth(thick)),
legend(off) yline(0) graphregion(color(white)) ytitle(change in mortality rate)
xlabel(25 30 35 40 45 50 55 60)
xtitle(five-year age group) ysize(3.2) xsize(3.8) ylabel(-400 -200 0 200 400) title(Women);
*saving(c:\aamortality102716\edresults\change_mort_byed_9815_F.gph, replace);
log close;

