cap log close
cap drop _all
set more off

log using graph_Fig1_8.log, replace
/* this creates for Figure 1.8  in Brookings paper */
# delimit ;

use "c:\users\accase\dropbox\mortality by cause by country by year\finalfiles9_10_update\rates\intl_rates_5yr.dta";

isid iso year age sex;
keep if age==50;
keep if sex==0;
keep iso year Hrate Crate PSLrate;
gen insamp =1 if iso =="USW"|iso=="USB"|iso=="USH"|iso=="AUS"|iso=="CAN"|iso=="FRA"|iso=="GER"|iso=="SWE"|iso=="UK" ;
keep if insamp==1; drop insamp;

reshape wide Hrate Crate PSLrate , i(year) j(isocode) string;


label var year "year";
drop if year<1989;
*gr two (line CrateUSW year  , lcolor(red) lwidth(thick)) (line CrateAUS year, lcolor(maroon) lwidth(medthick))
       (line CrateGER year  , lcolor(blue) lwidth(medthick) lp(longdash))
        (line CrateUK year  , lcolor(midgreen) lwidth(medthick)) (line CrateFRA year  , lcolor(green) lw(medthick))
       (line CrateSWE year  , lcolor(navy) lw(medthick) lp(longdash)) (line CrateCAN year  , lcolor(lavender) lw(medthick)), xlabel(1990 2000 2010) legend(off)
 ytitle("deaths per 100,000") title("Cancer mortality, men and women ages 50-54", size(med)) graphregion(color(white))
 ylabel(100 150 200 250) ;
* saving(..\results\Crate_5054_MF_intl.gph, replace) ;


gr two (line HrateUSW year  , lcolor(red) lwidth(thick)) (line HrateAUS year, lcolor(maroon) lwidth(medthick))
       (line HrateGER year  , lcolor(blue) lwidth(medthick) lp(longdash))
        (line HrateUK year  , lcolor(midgreen) lwidth(medthick)) (line HrateFRA year  , lcolor(green) lw(medthick))
       (line HrateSWE year  , lcolor(navy) lw(medthick) lp(longdash)) (line HrateCAN year  , lcolor(lavender) lw(medthick)), xlabel(1990 2000 2010) legend(off)
 ytitle("deaths per 100,000") title("Heart disease mortality, men and women ages 50-54", size(med)) graphregion(color(white))
 ylabel(50 100 150);
* saving(..\results\Hrate_5054_MF_intl.gph, replace) ;


*gr two (line PSLrateUSW year  , lcolor(red) lwidth(thick)) (line PSLrateAUS year, lcolor(maroon) lwidth(medthick))
       (line PSLrateGER year  , lcolor(blue) lwidth(medthick) lp(longdash))
        (line PSLrateUK year  , lcolor(midgreen) lwidth(medthick)) (line PSLrateFRA year  , lcolor(green) lw(medthick))
       (line PSLrateSWE year  , lcolor(navy) lw(medthick) lp(longdash)) (line PSLrateCAN year  , lcolor(lavender) lw(medthick)), xlabel(1990 2000 2010) legend(off)
 ytitle("deaths per 100,000") title("Drug, alcohol and suicide mortality, men and women ages 50-54", size(med) color(black)) graphregion(color(white))
 ylabel(25 50 75)
 saving(..\results\PSLrate_5054_MF_intl.gph, replace) ;

