cap log close
set more off
cap drop _all

/******************************************************************************************************/
/* this program reads data pulled from the BRFSS website to create BMI and at risk for heavy drinking */
/* these data are for white non-Hispanics ages 18-85 (<80 in later years)                            */
/* rewrite the code to call the data from the sub-directory you've used to store the brfss data     */
/* infiles: cdbrfs93.dta - cdbrfs10.dta and llcp2011.dta - llcp2015.dta pulled from BRFSS website  */
/**************************************************************************************************/

log using c:\users\accase\dropbox\brookings\archive\brfss\dofiles\combineBRFS.log,  replace
/* combining data from 1993-2015 to look at BMI and drinking in the BRFSS  */

/********************** 1993 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs93.dta
 keep if race ==1 & hispanic==2
 keep if age>=18 & age<=85
keep A_FINALWT age genhlth  sex weight height  educa  A_BMI
 gen BMI = A_BMI/10

 gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
 label var HTIN4 "height in inches"
 replace HTIN4=. if height>=777
 drop height

gen year =1993
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace


/********************** 1994 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs94.dta
keep if race ==1 & hispanic==2
keep if age>=18 & age<=85
keep A_FINALWT age genhlth  sex weight height  educa  A_BMI
 gen BMI = A_BMI/10

gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
label var HTIN4 "height in inches"
replace HTIN4=. if height>=777
drop height

gen year =1994
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 1995 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs95.dta
keep if race ==1 & hispanic==2
keep if age>=18 & age<=85
keep A_FINALWT age genhlth  sex weight height  educa  A_BMI
gen BMI=A_BMI/10

gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
label var HTIN4 "height in inches"
replace HTIN4=. if height>=777
drop height

gen year =1995
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace


/********************** 1996 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs96.dta
keep if race ==1 & hispanic==2
keep if age>=18 & age<=85
keep A_FINALWT age genhlth  sex weight height  educa  A_BMI
gen BMI = A_BMI/10


gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
label var HTIN4 "height in inches"
replace HTIN4=. if height>=777
drop height

gen year =1996
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 1997 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs97.dta
 keep if race ==1 & hispanic==2
 keep if age>=18 & age<=85
keep A_FINALWT age genhlth  sex weight height  educa A_BMI
 gen BMI = A_BMI/10


gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
label var HTIN4 "height in inches"
replace HTIN4=. if height>=777
drop height

gen year =1997
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 1998 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs98.dta
keep if race ==1 & hispanic==2
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex weight height  educa  A_BMI
  gen BMI = A_BMI/10


gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
label var HTIN4 "height in inches"
replace HTIN4=. if height>=777
drop height

gen year=1998
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 1999 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs99.dta
keep if race ==1 & hispanic==2
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex weight height  educa  A_BMI
  gen BMI = A_BMI/10

gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
label var HTIN4 "height in inches"
replace HTIN4=. if height>=777
drop height

gen year=1999
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace


/********************** 2000 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs00.dta
keep if race ==1 & hispanic==2
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex weight height  educa  A_BMI2
  gen BMI = A_BMI2/10

gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
label var HTIN4 "height in inches"
replace HTIN4=. if height>=777
drop height

gen year=2000
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace


/********************** 2001 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs01.dta
keep if RACE2==1
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex weight height  educa   A_RFDRHVY  A_BMI2
  gen BMI = A_BMI2/10000


gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
label var HTIN4 "height in inches"
replace HTIN4=. if height>=777
drop height

gen year=2001
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace


/********************** 2002 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs02.dta
keep if RACE2==1
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex weight height  educa   A_RFDRHV2    A_BMI2
 gen BMI = A_BMI2/100
ren A_RFDRHV2 A_RFDRHVY

gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
label var HTIN4 "height in inches"
replace HTIN4=. if height>=777
drop height

gen year=2002
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 2003 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs03.dta
keep if RACE2==1
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex weight height  educa   A_RFDRHV2 A_BMI3
 gen BMI = A_BMI3/100

ren A_RFDRHV2 A_RFDRHVY

gen HTIN4 = int(height/100)*12 + ( height - int(height/100)*100)
label var HTIN4 "height in inches"
replace HTIN4=. if height>=777
drop height

gen year=2003
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 2004 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs04.dta
keep if RACE2==1
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex WEIGHT2  HTIN3  educa  A_RFDRHV2    A_BMI4
 gen BMI = A_BMI4/100


ren A_RFDRHV2 A_RFDRHVY
ren HTIN3 HTIN4
ren WEIGHT2 weight

replace HTIN4=. if HTIN4==999

gen year=2004
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 2005 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs05.dta
keep if RACE2==1
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex WEIGHT2 HTIN3  educa   A_RFDRHV3 A_BMI4
 gen BMI = A_BMI4/100

ren A_RFDRHV3 A_RFDRHVY
ren HTIN3 HTIN4
ren WEIGHT2 weight

replace HTIN4=. if HTIN4==999

gen year=2005
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 2006 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs06.dta
keep if RACE2==1
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex WEIGHT2 HTIN3  educa  A_RFDRHV3  A_BMI4
 gen BMI = A_BMI4/100

ren A_RFDRHV3 A_RFDRHVY
ren HTIN3 HTIN4
ren WEIGHT2 weight
replace HTIN4=. if HTIN4==999

gen year=2006
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace


/********************** 2007 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs07.dta
keep if RACE2==1
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex WEIGHT2 HTIN3  educa  A_RFDRHV3  A_BMI4
 gen BMI = A_BMI4/100

ren A_RFDRHV3 A_RFDRHVY
ren HTIN3 HTIN4
ren WEIGHT2 weight
replace HTIN4=. if HTIN4==999

gen year=2007
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 2008 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs08.dta
keep if RACE2==1
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex WEIGHT2 HTIN3  educa  A_RFDRHV3  A_BMI4
 gen BMI = A_BMI4/100

ren A_RFDRHV3 A_RFDRHVY
ren HTIN3 HTIN4
ren WEIGHT2 weight
replace HTIN4=. if HTIN4==999

gen year=2008
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 2009 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs09.dta
keep if RACE2==1
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex WEIGHT2 HTIN3  educa  A_RFDRHV3 A_BMI4
 gen BMI = A_BMI4/100

ren A_RFDRHV3 A_RFDRHVY
ren HTIN3 HTIN4
ren WEIGHT2 weight
replace HTIN4=. if HTIN4==999

gen year=2009
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace


/********************** 2010 ********************************/
use c:\users\accase\dropbox\brfss\data\cdbrfs10.dta
keep if RACE2==1
keep if age>=18 & age<=85

keep A_FINALWT age genhlth  sex WEIGHT2 HTIN3  educa  A_RFDRHV3  A_BMI4
 gen BMI = A_BMI4/100

ren A_RFDRHV3 A_RFDRHVY
ren HTIN3 HTIN4
ren WEIGHT2 weight
replace HTIN4=. if HTIN4==999

gen year=2010
append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 2011 ********************************/
use c:\users\accase\dropbox\brfss\data\llcp2011.dta
keep if RACE2==1
keep if age>=18 & age<=85
keep A_LLCPWT age genhlth  sex WEIGHT2 HTIN4  educa   A_RFDRHV4 A_BMI5
  gen BMI = A_BMI5/100

ren A_RFDRHV4 A_RFDRHVY
ren A_LLCPWT A_FINALWT
ren WEIGHT2 weight
gen year = 2011

append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 2012 ********************************/
use c:\users\accase\dropbox\brfss\data\llcp2012.dta
keep if RACE2==1
keep if age>=18 & age<=85
keep A_LLCPWT age genhlth  sex WEIGHT2 HTIN4  educa   A_RFDRHV4  A_BMI5
  gen BMI = A_BMI5/100

ren A_RFDRHV4 A_RFDRHVY
ren A_LLCPWT A_FINALWT
ren WEIGHT2 weight
gen year = 2012

append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 2013 ********************************/
use c:\users\accase\dropbox\brfss\data\llcp2013.dta

keep if A_IMPRACE==1
ren A_AGE80 age
keep if age>=18 & age<80
/* NB: in 2013, age 80 includes ages 80-99   */
/* so for 2013 don't include 80-85 year olds */
keep A_LLCPWT age genhlth  sex WEIGHT2 HTIN4  educa   A_RFDRHV4  A_BMI5
  gen BMI = A_BMI5/100

ren A_RFDRHV4 A_RFDRHVY
ren A_LLCPWT A_FINALWT
ren WEIGHT2 weight
gen year = 2013

append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

/********************** 2014 ********************************/
use c:\users\accase\dropbox\brfss\data\llcp2014.dta

keep if _imprace==1
ren _age80 age
keep if age>=18 & age<80
/* NB: in 2014, age 80 includes ages 80-99   */
/* so for 2014 don't include 80-85 year olds */

gen BMI = _bmi5/100

keep _llcpwt age genhlth  sex BMI  educa  _rfdrhv4

ren _rfdrhv4 A_RFDRHVY
ren _llcpwt  A_FINALWT

gen year = 2014

append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace


/********************** 2015 ********************************/
use c:\users\accase\dropbox\brfss\data\llcp2015.dta

keep if _race==1
ren _age80 age
keep if age>=18 & age<80
/* NB: in 2014+, age 80 includes ages 80-99   */
/* so for 2014+ don't include 80-85 year olds */

gen BMI = _bmi5/100

keep _llcpwt age genhlth  sex BMI  educa  _rfdrhv5

ren _rfdrhv5 A_RFDRHVY
ren _llcpwt  A_FINALWT

gen year = 2015

append using c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta
save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace


replace HTIN4 =. if HTIN4>100
replace weight =. if weight>500


label var age  "age"

*gen bmiWH = (703*weight)/(HTIN4^2)
*label var bmiWH "(703*weight)/(HTIN4^2) constructed"
/* BMI constructed by BRFSS is almost identical to BMI constructed. Use BMI from BRFSS */

/* remove biggest outliers */
replace BMI=. if BMI<12 | BMI>90
sum BMI if age>=30, det


replace genhlth=. if genhlth>5
gen ind_EVG = genhlth>=1 & genhlth<=2
replace ind_EVG =. if genhlth==.
label var ind_EVG "=1 if excellent/very good health"


gen ind_RFDR =1    if A_RFDRHVY==2
replace ind_RFDR=0 if A_RFDRHVY==1
label var ind_RFDR "at risk heavy drinking"

gen edclass=.
replace edclass=1 if educa<=4
replace edclass=2 if educa==5
replace edclass=3 if educa==6

label def edlab 1 "LEHS" 2 "SomeC" 3 "BA+"
label val edclass edlab

label def sexlab 1 male 2 female
label val sex sexlab
label data "white non-Hispanics BRFSS 1993-2015"

keep year sex age genhlth ind_EVG educa edclass A_RFDR ind_RFDR BMI weight HTIN4  A_FINAL

save c:\users\accase\dropbox\brookings\archive\brfss\data\combineBRFS.dta, replace

log close
