% load data
addpath('../FRBUS')
addpath('../DSGE')
% FRBUS
fstrn=[ ...
      'linver_itay_results.mat'];
% DSGE
fstrl=[ ...
      'LSW_itay_results.mat'];

%create irf_1
load(fstrn)
amat=oo_.dr.ghx(M_.nstatic+1:M_.nstatic+M_.nspred,:);
bmat = oo_.dr.ghu(M_.nstatic+1:M_.nstatic+M_.nspred,:);
idrff=oo_.dr.inv_order_var(222)-M_.nstatic;
idpicx4=oo_.dr.inv_order_var(168)-M_.nstatic;
idgap=oo_.dr.inv_order_var(301)-M_.nstatic;
idsh =64;
irfmat_1(1,1:3) = bmat([idgap,idpicx4,idrff],idsh)';
abmat=bmat;
for ij=2:40,
   abmat=amat*abmat;   
   irfmat_1(ij,:) = abmat([idgap,idpicx4,idrff],idsh)';
end

%create irf_3
load(fstrl)
amat=zeros(M_.nstatic+M_.nspred+M_.nfwrd,M_.nstatic+M_.nspred+M_.nfwrd);
amat(:,M_.nstatic+1:M_.nstatic+M_.nspred)=oo_.dr.ghx(:,:);
bmat = oo_.dr.ghu;
idrff=oo_.dr.inv_order_var(2); %endo 222 (rffe) in declaration order, 298 in
                      %dr order from inv_order_var
idpicx4=oo_.dr.inv_order_var(56); %picx4 is 168 (dr order 258)
idgap=oo_.dr.inv_order_var(59); %xgap2 is 301 (dr order 341)
idrffsh=oo_.dr.inv_order_var(48); %rffsh is variable 545;
% rff_ is shock 64:nrffsh+63
idsh =10;
irfmat_3(1,1:3) = bmat([idgap,idpicx4,idrff],idsh)';
abmat=bmat;
for ij=2:40,
   abmat=amat*abmat;   
   irfmat_3(ij,:) = abmat([idgap,idpicx4,idrff],idsh)';
end
irfmat_3(:,1) = irfmat_3(:,1)/4;
% Make some figures...
figure
subplot(2,1,1)
plot(irfmat_1./irfmat_1(1,3))
title('FRB/US')
ylim([-.7,1])
ylabel('Percent')
%subplot(3,1,2)
%plot(irfmat_2./irfmat_2(1,3))
%title('Williams FRB/US')
%ylim([-.7,1])
subplot(2,1,2)
plot(irfmat_3./irfmat_3(1,3))
title('Linde-Smets-Wouters (2016)')
ylim([-.7,1])
ylabel('Percent')
print('irfest_fig','-depsc')

figure
subplot(2,1,1)
run_irfFG_FRB;%load('/ofs/research-m1mtk00/Brookings/FRBUS/mceverf/irfFG.mat')
plot(-irfmat_3./irfmat_3(12,3))
title('FRB/US')
ylim([-1.25,3])
ylabel('Percent')
%subplot(3,1,2)
%plot(irfmat_2./irfmat_2(1,3))
%title('Williams FRB/US')
%ylim([-.7,1])

subplot(2,1,2)
load('/ofs/research-m1mtk00/Brookings/DSGEX/irfFG.mat')
plot(-irfmat_3./irfmat_3(12,3))
title('Linde-Smets-Wouters (2016)')
ylim([-1.25,3])
ylabel('Percent')
print('irffg_fig','-depsc')
