clear all;
addpath('../DSGE')
% graph normpdf of r for mean of 6:0 and s.d. of 3.25
targs = [6,4,3,2];
for hh = 1:4
fstrn=[...
      'results_taylor99_',num2str(targs(hh))];
load(fstrn,'-mat')
DSGE_load
yc(hh,:)={y'};
pc(hh,:)={p'+2};
zc(hh,:)={z'+targs(hh)};
end
for hh = 1:4
yt=cell2mat(yc(hh,:));[ff,xx]=ksdensity(yt);fyc(hh,:)=ff;xyc(hh,:)=xx;
pt=cell2mat(pc(hh,:));[ff,xx]=ksdensity(pt);fpc(hh,:)=ff;xpc(hh,:)=xx;
zt=cell2mat(zc(hh,:));[ff,xx]=histc(zt,[-14.75:1:14.75]);fzc(hh,:)=ff;xzc(hh,:)=[-14.75:1:14.75];%xx;
end
figure(1)
subplot(3,2,1);
plot(xyc(1,:),fyc(1,:),'-k');hold on
plot(xyc(2,:),fyc(2,:),'--b');hold on
plot(xyc(3,:),fyc(3,:),'-.g');hold on
plot(xyc(4,:),fyc(4,:),'-.r');hold on
xlim([-15,15])%legend('r*=4','r*=2','r*=1','r*=0')
%legend('boxoff')
title('Output')
subplot(3,2,3);
plot(xpc(1,:),fpc(1,:),'-k');hold on
plot(xpc(2,:),fpc(2,:),'--b');hold on
plot(xpc(3,:),fpc(3,:),'-.g');hold on
plot(xpc(4,:),fpc(4,:),'-.r');hold on
xlim([-10,10])
%ylim([0,.3])
title('Inflation')
subplot(3,2,5);
plot(xzc(1,:),fzc(1,:)/50000,'-k');hold on
plot(xzc(2,:),fzc(2,:)/50000,'--b');hold on
plot(xzc(3,:),fzc(3,:)/50000,'-.g');hold on
plot(xzc(4,:),fzc(4,:)/50000,'-.r');hold on
xlim([-.9,10])
ylim([0,.7])
title('Nominal Interest Rate')
%legend('r*=4','r*=2','r*=1','r*=0')
%legend('boxoff')
%set(gca,'Xtick',[-3,0,3,6,9,12,15])
%print('figd_dens_tay99','-dpng')
