% load data
addpath('../DSGE')
clear all;

%Names = {'No ELB','i* = 5','i* = 4', 'i* = 3', 'i* = 2'};

varn = {' ','ELB freq.','Mean ELB duration','mean(y)','mean(dp)(dp*=2)','RMSD(y)','RMSD(dp)'};

targs = [8:-.25:2];
for hh = 1:25
fstrn=[ ...
      'results_taylor99_',num2str(targs(hh))];
load(fstrn,'-mat')
FRB_load
nstar(hh,1) = {(targs(hh))};
mgap(hh,1) = {mean(y)};
mdp(hh,1) = {mean(4*p)};
mpnb(hh,1) = {mean(4*p(4*z>min(4*z+.25)))};
rgap(hh,1) = {mean(y.^2)^.5};
rdp(hh,1) = {mean((4*p).^2)^.5};
felb(hh,1) = {100*sum(4*z<-targs(hh)+.25)/sum(z<Inf)};
delb(hh,1) = {mean(d(d>0))};
end 

% Make some tables...

T(:,1) = nstar;
T(:,2) = felb;
T(:,3) = delb;
T(:,4) = mgap;
T(:,5) = mdp;
T(:,6) = rgap;
T(:,7) = rdp;

T = [varn;T]

mdpm=cell2mat(mdp);
mgapm=cell2mat(mgap);
nstarm=cell2mat(nstar);
rstarm=cell2mat(nstar)-2;

[nstarm, rstarm, mdpm, mgapm]

xalt=rstarm;%[0:6]';
subplot(3,2,[1,2])
plot(rstarm,min([mdpm+2],2));hold on
%plot(xalt,[[ones(size(xalt(1:6,:))),xalt(1:6,:),xalt(1:6,:).^2]*beta;2;2;2]);hold on
plot(xalt,2*ones(size(xalt)),'--b','LineWidth',1)
xlabel('r*')
%ylim([0,2])
ylabel('percent')
title('Average Inflation without risk adjustment')

% compute risk adjustment
% start at r*=0
endn=max(size(mdpm));
for endl=endn:-1:1
    test=0;
if mdpm(endl)+2<1.95
    test=1;
    ggg=1;
    while test>0
        ggg=ggg+1;
        if mdpm(endl-(ggg-1))+2+(ggg-1)*.25>1.95 & mdpm(endl-(ggg-2))+2+(ggg-2)*.25< ...
                1.95
            xw= (2-[mdpm(endl-(ggg-2))+2+(ggg-2)*.25])/ ...
                ([mdpm(endl-(ggg-1))+2+(ggg-1)*.25]-[mdpm(endl- ...
                                                           (ggg- ...
                                                            2))+2+ ...
                       (ggg-2)*.25])
            %xw=lsqlin([mdpm(endl-(ggg-1))+2+(ggg-1)*.25,mdpm(endl- ...
            %                                               (ggg- ...
            %                                                2))+2+ ...
            %           (ggg-2)*.25],2,[],[],[],[],zeros(2,1),ones(2,1))
            
            
            rstara(endl,1)=(ggg-1)*.25*xw(1)+(ggg-2)*.25*(1-xw(1));
            rstarg(endl,1)=ggg;
            wadj(endl,1:2) = [xw;1-xw];
            test=0;
        end
    end
else
    rstara(endl)=0;
    wadj(endl,1:2) = [0,1];
end
end

% If we like these pictures, can invest in the right quantities

radj = -rstara;
subplot(3,2,[3,4])
plot(rstarm,radj);hold on
%plot(xalt,-radj);hold on
plot(rstarm,0*ones(size(xalt)),'--b')
xlabel('r*')
ylabel('percentage points')
title('Risk adjustment to achieve inflation of 2 percent')

% If we like these pictures, can invest in the right quantities
for endl=endn:-1:1
    gadj(endl,1) = mgapm(endl-(max(rstarg(endl),1)-1))*wadj(endl,1)+mgapm(endl-(max(rstarg(endl),2)-2))*wadj(endl,2);
end
%gadj = [.235;.17;.11;0.05;0.02;0;0];%.0;0]
subplot(3,2,5)
plot(rstarm,gadj);hold on
plot(rstarm,0*ones(size(xalt)),'--b')
xlabel('r*')
ylabel('percent')
title({'Average shortfall of output','from potential with risk adjustment'})

mpnbm=cell2mat(mpnb);
for endl=endn:-1:1
    padj(endl,1) = 2+((max(rstarg(endl),1)-1)*.25+mpnbm(endl-(max(rstarg(endl),1)-1)))*wadj(endl,1)+((max(rstarg(endl),2)-2)*.25+mpnbm(endl-(max(rstarg(endl),2)-2)))*wadj(endl,2);
end

subplot(3,2,6)
plot(rstarm,padj);hold on
plot(rstarm,2*ones(size(xalt)),'--b')
xlabel('r*')
ylabel('percent')
title({'Average inflation when interest','rate exceeds ELB'})
print('dsge_riskadj','-depsc')
