fig_dens_tay99
clear all;
% graph normpdf of r for mean of 6:0 and s.d. of 3.25
targs = [6,4,3,2];
for hh = 1:4
fstrn=[ ...
      'results_taylor99_',num2str(targs(hh))];
load(fstrn,'-mat')
FRB_load
yc(hh,:)={y'};
pc(hh,:)={p'+2};
zc(hh,:)={z'+targs(hh)};
end
for hh = 1:4
yt=cell2mat(yc(hh,:));[ff,xx]=ecdf(yt);fyc(hh,:)=ff;xyc(hh,:)=xx;
pt=cell2mat(pc(hh,:));[ff,xx]=ecdf(pt);fpc(hh,:)=ff;xpc(hh,:)=xx;
end
figure(1)
subplot(3,2,2);
plot(xyc(1,:),fyc(1,:),'-k');hold on
plot(xyc(2,:),fyc(2,:),'--b');hold on
plot(xyc(3,:),fyc(3,:),'-g');hold on
plot(xyc(4,:),fyc(4,:),'-.r');hold on
legend('r*=4','r*=2','r*=1','r*=0')
legend('boxoff')
xlim([-15,15])
title('Output')
subplot(3,2,4);
plot(xpc(1,:),fpc(1,:),'-k');hold on
plot(xpc(2,:),fpc(2,:),'--b');hold on
plot(xpc(3,:),fpc(3,:),'-g');hold on
plot(xpc(4,:),fpc(4,:),'-.r');hold on
title('Inflation')
xlim([-10,10])
subplot(3,2,6);
zt1=cell2mat(zc(1,:));
[ff1,xx1]=ecdf(zt1);
zt2=cell2mat(zc(2,:));
[ff2,xx2]=ecdf(zt2);
zt3=cell2mat(zc(3,:));
[ff3,xx3]=ecdf(zt3);
zt4=cell2mat(zc(4,:));
[ff4,xx4]=ecdf(zt4);
plot(xx1,ff1,'-k');hold on
plot(xx2,ff2,'--b');hold on
plot(xx3,ff3,'-g');hold on
plot(xx4,ff4,'-.r');hold on
xlim([-.90,10])
title('Nominal Interest Rate')
%legend('r*=4','r*=2','r*=1','r*=0')
%legend('boxoff')
%set(gca,'Xtick',[-3,0,3,6,9,12,15])
print('fig_ecdf_tay99','-depsc')
