% load data
addpath('../ELBcode')
addpath('../FRBUS')
clear all;

%Names = {'No ELB','i* = 5','i* = 4', 'i* = 3', 'i* = 2'};

varn = {' ','ELB freq.','Mean ELB duration','mean(y)','mean(dp)(dp*=2)','RMSD(y)','RMSD(dp)'};

targs = [8:-.25:2];
for hh = 1:25
fstrn=[ ...
      'results_taylor99_',num2str(targs(hh))];
load(fstrn,'-mat')
FRB_load
nstar(hh,1) = {(targs(hh))};
mgap(hh,1) = {mean(y)};
mdp(hh,1) = {mean(p)};
mpnb(hh,1) = {mean(p(z>min(z+.25)))};
rgap(hh,1) = {mean(y.^2)^.5};
rdp(hh,1) = {mean((p).^2)^.5};
vdp(hh,1) = {var(p)};
felb(hh,1) = {100*sum(z<-targs(hh)+.25)/sum(z<Inf)};
delb(hh,1) = {mean(d(d>0))};
end 

% Make some tables...

T(:,1) = nstar;
T(:,2) = felb;
T(:,3) = delb;
T(:,4) = mgap;
T(:,5) = mdp;
T(:,6) = rgap;
T(:,7) = rdp;

T = [varn;T]

mdpm=cell2mat(mdp);
mgapm=cell2mat(mgap);
nstarm=cell2mat(nstar);
rstarm=cell2mat(nstar)-2;
rgapm=cell2mat(rgap);
vdpm=cell2mat(rdp);

[nstarm, rstarm, mdpm, mgapm]

wel1a= flipud(.25*(rgapm.^2));
wel1b= flipud(vdpm);
wel1c= flipud((nstarm-1+mdpm -2).^2);
welg=-3:1:5;welg=welg';pig=-1:7;pig=pig';
wel1=(wel1a+wel1b+wel1c);
pi1 = flipud(nstarm-1+mdpm);
wel2c= flipud((nstarm-2+mdpm -2).^2);
wel2=(wel1a+wel1b+wel2c);
pi2 = flipud(nstarm-2+mdpm);
wel3c= flipud((nstarm-3+mdpm -2).^2);
wel3=(wel1a+wel1b+wel3c);
pi3 = flipud(nstarm-3+mdpm);


xalt=rstarm;%[0:6]';
subplot(1,3,1)
plot([pi1,pi2,pi3],[wel1,wel2,wel3])
legend({'r*=1','r*=2','r*=3'})
%xlabel('Inflation target')
xlim([0,6])
ylabel('Losses')
title('Alternative r*')


wel1a= flipud((rgapm.^2));
wel1b= flipud(vdpm);
wel1c= flipud((nstarm-1+mdpm -2).^2);
welg=-3:1:5;welg=welg';pig=-1:7;pig=pig';
wel1=(wel1a+wel1b+wel1c);
pi1 = flipud(nstarm-1+mdpm);
wel2c= flipud((nstarm-2+mdpm -2).^2);
wel2=(wel1a+wel1b+wel2c);
pi2 = flipud(nstarm-2+mdpm);
wel3c= flipud((nstarm-3+mdpm -2).^2);
wel3=(wel1a+wel1b+wel3c);
pi3 = flipud(nstarm-3+mdpm);


xalt=rstarm;%[0:6]';
subplot(1,3,2)
plot([pi1,pi2,pi3],[wel1,wel2,wel3])
%legend({'r*=1','r*=2','r*=3'})
xlabel('Inflation target')
xlim([0,6])
%ylabel('Losses')
title('Higher output weight')

wel1a= flipud((rgapm.^2));
wel1b= flipud(vdpm);
wel1c= flipud((nstarm-1+mdpm).^2);
welg=-3:1:5;welg=welg';pig=-1:7;pig=pig';
wel1=(wel1a+wel1b+wel1c);
pi1 = flipud(nstarm-1+mdpm);
wel2c= flipud((nstarm-2+mdpm).^2);
wel2=(wel1a+wel1b+wel2c);
pi2 = flipud(nstarm-2+mdpm);
wel3c= flipud((nstarm-3+mdpm).^2);
wel3=(wel1a+wel1b+wel3c);
pi3 = flipud(nstarm-3+mdpm);


xalt=rstarm;%[0:6]';
subplot(1,3,3)
plot([pi1,pi2,pi3],[wel1,wel2,wel3])
%legend({'r*=1','r*=2','r*=3'})
%xlabel('Inflation target')
xlim([0,6])
%ylabel('Losses')
title({'Higher output weight &','Optimal inflation equals 0'})

print('w_frb','-depsc')
