
version 13.1
# delimit ;
cap log close;

clear;
drop _all;
cd "C:\Users\accase\dropbox\Mortality by cause by country by year";
log using "c:\users\accase\dropbox\mortality by cause by country by year\dofiles\process_who_icd10_update.log", replace;
set more off;
tempfile temp;
use c:\users\accase\dropbox\hmd\HMDUpdata\morticd10_part1.dta;
drop subdiv;
append using c:\users\accase\dropbox\hmd\HMDUpdata\morticd10_part2.dta;
drop subdiv;

* we only want to keep specific countries:;
	keep if inlist(country,2450,4308,4085,4080,2090,5020,4290,4240,4170,4140,4280,
3160,4180,4070,4010,4020,4038,4045,4055,4070,4150,4160,4210,4220,4230,4300,4274,4276,4030,3080,4188,4190,4186,4200,4270,4050,4330);
	
*Prepare the data;
   *drop if sex not male or female;
   	drop if sex==9;
   	
	sort country;
	
	gen str1 let_1=substr(cause,1,1);
	gen num_3=real(substr(cause,2,3));

        *if cause equals AAA total deaths from all causes combined, so we will drop it;
        drop if cause=="AAA";

        sort country year sex;
	*get country names;
	merge m:1 country using infiles\country_codes;
		*drop countries we are not using;
		drop if _m==2;
		drop _m;
		rename name country_name;
	labmask country, values(country_name);
	numlabel,add;
	*deaths;	
		gen deaths_all=deaths1;
		gen deaths_uns=deaths26;
		rename	deaths9	deaaths15_19;
		rename	deaths10 deaths20_24;
		rename	deaths11	deaths25_29;
		rename	deaths12	deaths30_34;
		rename	deaths13	deaths35_39;
		rename	deaths14	deaths40_44;
		rename	deaths15	deaths45_49;
		rename	deaths16	deaths50_54;
		rename	deaths17	deaths55_59;
		rename	deaths18	deaths60_64;
		rename	deaths19	deaths65_69;
		rename	deaths20	deaths70_74;
				
		drop  frmat admin deaths1 deaths2 deaths3 deaths4 deaths5 deaths6 deaths7 deaths8
		deaths21 deaths22 deaths23 deaths24 deaths25 deaths26 im_*;

save "`temp'",replace;

**ALL DEATHS ***;
/***************************
***************************/
use "`temp'",clear;
	collapse (sum) deaths*, by(country country_name year sex);

	do dofiles\process_deaths.do;
	gen icd=10;
save outfiles\alldeathsicd10_update.dta,replace;


**POISON**;
/*******************/
/*** poison ***/
	use "`temp'",clear;
	gen pois =0;

		replace pois=1 if (let_1=="Y" & num_3 >=100 & num_3 <= 159)|(let_1=="Y" & num_3>=10 & num_3 <=15 & length(cause)==3);
		replace pois=1 if (let_1=="X" & num_3 >=400 & num_3 <= 449)|(let_1=="X" & num_3>=40 & num_3 <=44 & length(cause)==3);
	
keep if pois==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 10;

save outfiles\poisonicd10_update.dta, replace;


/*******************/
/*** SUICIDE ***/
/***************/
use "`temp'",clear;
gen suicide = 0;
replace suicide=1 if (let_1=="X" & num_3 >=600 & num_3 <= 849)|(let_1=="X" & num_3>=60 & num_3 <=84 & length(cause)==3)|(cause=="Y870");

keep if suicide==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 10;

save outfiles\suicideicd10_update.dta, replace;

/*******************/
/*** liver ***/
use "`temp'",clear;
gen liver = 0;
replace liver=1 if (let_1=="K" & num_3 >=700 & num_3 <= 709)|(let_1=="K" & num_3>=730 & num_3 <=749)|let_1=="K" &num_3==70 & length(cause)==3;
replace liver=1 if (let_1=="K" & num_3==73 & length(cause)==3)|(let_1=="K" & num_3==74 & length(cause)==3);

keep if liver==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 10;

save outfiles\livericd10_update.dta, replace;

/*******************/
/*** heart disease ***/
use "`temp'",clear;
gen heart=0;
/*
replace heart =1 if substr(icd10,1,1)=="I" & num>=10 & num<=99 & length(icd10)==4;
replace heart=1 if ((inlist(num,0,11,13) & length(icd10)==3)|((num>=20& num<=51) & length(icd10)==3)) & xcode=="I";
replace heart=1 if (num>=200& num<=519 & length(icd10)==4)& xcode=="I";
replace heart=1 if inlist(substr(icd10,1,3),"I11","I13");
*/
replace heart =1 if (substr(cause,1,2)=="I0" &num_3>=0 & num_3 <=99);
replace heart=1 if heart==0 & substr(cause,1,3)=="I11" & num_3>=110 & num_3<=119;
replace heart=1 if heart==0 & substr(cause,1,3)=="I13" & num_3>=130 & num_3<=139;
replace heart=1 if heart==0 & let_1=="I" & num_3>=200 & num_3<=519;
replace heart=1 if heart==0 & let_1=="I" & num_3>=20 & num_3<=51 & length(cause)==3;


keep if heart==1;

collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 10;

save outfiles\hearticd10_update.dta, replace;

/*** cancer disease ***/
use "`temp'",clear;
gen cancer=0;
*pick up all of cancer;
replace cancer=1 if substr(cause,1,1)=="C";


keep if cancer==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd = 10;

save outfiles\cancericd10_update.dta, replace;

/*******************/
/*** Lung cancer disease ***/
use "`temp'",clear;

gen lungC=0;
replace lungC=1 if substr(cause,1,3)=="C34";

keep if lungC==1;
collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd=10;

save outfiles\lungCicd10_update.dta, replace;

/*******************/
/*** Diabetes disease ***/
use "`temp'",clear;

gen diabetes=0;
replace diabetes=1 if let_1=="E" & num_3 >=100 & num_3 <=149;

keep if diabetes==1;

collapse (sum) deaths*, by(country country_name year sex);
do dofiles\process_deaths.do;
gen icd=10;

save outfiles\diabetesicd10_update.dta, replace;

*log close;
