cap log close
cap drop _all
set more off
version 13.1
clear

/* reading mortality by single years of age from 1989-2015 for WNH BNH and Hisp by sex  */

# delimit ;
log using c:\mortality102716\dofiles\read_mort8915.log, replace;
cd "C:\mortality 04122016";

tempfile tempbig;

use infiles\Mort1989.dta;

        /* for now, ignore foreign residents - they aren't in population denominators  */
        /* and keep only those with age in years */
        drop if resstatus>3;
        keep if ageunit==0;
        keep if age>=25 & age<=74;

keep year region educ89 hisprec sex age fipsstr fipsctyr icd icdn icd282;
/* CDC doesn't count hispanic origin unknown in its counts by ethnicity - only in its overall mortality count */
        ren icd icd9;
        ren icdn icd9n;

        gen ind_WNH = hisprec==6;                replace ind_WNH=. if hisprec==9;
        gen ind_BNH = hisprec==7;                replace ind_BNH=. if hisprec==9;
        gen ind_hisp = hisprec>=1 & hisprec<=5; replace ind_hisp=. if hisprec==9;

        gen edclass=1 if educ89<=12;
        replace edclass=2 if educ89>=13 & educ89<=15;
        replace edclass=3 if educ89>=16 & educ89<=17;


save `tempbig', replace;

forval i = 90(1) 98 {;
use infiles\Mort19`i'.dta;

        drop if resstatus>3;
        keep if ageunit==0;
        keep if age>=25 & age<=74;

keep year region educ89 hisprec sex age fipsstr fipsctyr icd icdn icd282;
        ren icd icd9;
        ren icdn icd9n;
        gen ind_WNH = hisprec==6; replace ind_WNH=. if hisprec==9;
        gen ind_BNH = hisprec==7; replace ind_BNH=. if hisprec==9;
        gen ind_hisp = hisprec>=1 & hisprec<=5; replace ind_hisp=. if hisprec==9;

        gen edclass=1 if educ89<=12;
        replace edclass=2 if educ89>=13 & educ89<=15;
        replace edclass=3 if educ89>=16 & educ89<=17;

append using `tempbig';
save `tempbig', replace;
};


forval i = 1999(1) 2002 {;
use infiles\Mort`i'.dta;

        drop if resstatus>3;
        keep if ageunit==0;
        keep if age>=25 & age<=74;

keep year region educ89 hisprec sex age fipsstr fipsctyr icd10 icd358;
        gen icd358R = real(icd358);
        drop icd358; ren icd358R icd358;

        gen ind_WNH = hisprec==6; replace ind_WNH=. if hisprec==9;
        gen ind_BNH = hisprec==7; replace ind_BNH=. if hisprec==9;
        gen ind_hisp = hisprec>=1 & hisprec<=5; replace ind_hisp=. if hisprec==9;

        gen edclass=1 if educ89<=12;
        replace edclass=2 if educ89>=13 & educ89<=15;
        replace edclass=3 if educ89>=16 & educ89<=17;

append using `tempbig';
save `tempbig', replace;
};


forval i = 2003(1)2014 {;
use infiles\Mort`i'.dta;

ren fipsstr stlab;
merge m:1 stlab using infiles\state_lab_fips, keepusing(stlab st_FIPS);
        tab stlab if _m==1;
        drop if _m==1; drop _m;
        ren st_FIPS fipsstr;


drop if resstatus>3;
keep if ageunit==1;
keep if age>=25 & age<=74;

keep year educ* hisprec sex age fipsstr fipsctyr icd10 icd358;
        gen sexx=1 if sex=="M";
        replace sexx=2 if sex=="F";
        drop sex; ren sexx sex;

        gen icd358R = real(icd358);
        drop icd358; ren icd358R icd358;

        gen ind_WNH = hisprec==6; replace ind_WNH=. if hisprec==9;
        gen ind_BNH = hisprec==7; replace ind_BNH=. if hisprec==9;
        gen ind_hisp = hisprec>=1 & hisprec<=5; replace ind_hisp=. if hisprec==9;

gen edclass=1 if educ89<=12 ;
replace edclass=2 if educ89>12  & educ89<=15 ;
replace edclass=3 if educ89>=16  & educ89<=17 ;
replace edclass=1 if educ20003<=3 & educflag==1;
replace edclass=2 if educ20003>=4 & educ20003<=5 & educflag==1;
replace edclass=3 if educ20003>=6 & educ20003<=8 & educflag==1;

append using `tempbig';
save `tempbig', replace;
};


use infiles\Mort2015.dta;


drop if restatus>3;

gen ageint = int(age/1000);
keep if ageint==1;
replace age = age-1000;
replace age =. if age==999;

keep if age>=25 & age<=74;

gen sexx=1 if sex=="M";
replace sexx=2 if sex=="F";
drop sex; ren sexx sex;
ren ucod icd10;

keep year educ* hspanicr  sex age icd10 ;

        gen ind_WNH  = hspanicr==6;                replace ind_WNH=.  if hspanicr==9;
        gen ind_BNH  = hspanicr==7;                replace ind_BNH=.  if hspanicr==9;
        gen ind_hisp = hspanicr>=1 & hspanicr <=5; replace ind_hisp=. if hspanicr==9;

rename educ1989 educ;

gen edclass=1 if educ<=12 ;
replace edclass=2 if educ>12  & educ<=15 ;
replace edclass=3 if educ>=16  & educ<=17 ;
replace edclass=1 if educ2003<=3 & educflag==1;
replace edclass=2 if educ2003>=4 & educ2003<=5 & educflag==1;
replace edclass=3 if educ2003>=6 & educ2003<=8 & educflag==1;
append using `tempbig';
save `tempbig', replace;
d;
    gen race=1 if ind_WNH==1;
replace race=2 if ind_BNH==1;
replace race=3 if ind_hisp==1;
tab hisprec if race==.;

/* these are NH other races and hisp origin UNK */
*drop if race ==.;

label var race "1 WNH 2 BNH 3 Hisp";

    gen age_gp=25 if age>=25 & age<=29;
replace age_gp=30 if age>=30 & age<=34;
replace age_gp=35 if age>=35 & age<=39;
replace age_gp=40 if age>=40 & age<=44;
replace age_gp=45 if age>=45 & age<=49;
replace age_gp=50 if age>=50 & age<=54;
replace age_gp=55 if age>=55 & age<=59;
replace age_gp=60 if age>=60 & age<=64;
replace age_gp=65 if age>=65 & age<=69;
replace age_gp=70 if age>=70 & age<=74;
label var age_gp "25-29, 30-34, etc.";

replace edclass = 99 if edclass==.;
label def edlab 1 "LEHS" 2 "SomeC" 3 "4+yrs" 99 "missing";
label val edclass edlab;

save c:\mortality102716\outfiles\mort_8915, replace;
log close;

