cap log close
set more off
cap drop _all
log using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\make_WNHsa_1997_2015.log, replace

******  this is the code rebuilt July 2015 to incorporate the 2015 NHIS data *********************
******  it adds some variables to the sa.dta data created using NHIS_sample_adult.do  ************
/*      it uses data pulled directly from the NHIS website: personsx1997.dta - personsx2015.dta  */

/************ 1997 *********************************************/
use c:\users\accase\dropbox\nhis_alice\infiles\personsx1997.dta

/* keep variables we want */

keep srvy_yr hhx fmx px age_p sex  racerec origin educ doinglw phstat plawklim astatflg region  wtfa ernyr_p

ren srvy_yr year
label drop pep002x
ren age_p age

replace year = 1997
ren phstat   hstat

/* restrict the sample:                                                  */
/* white non-hispanics ages 25+ who responded entirely for themselves    */
/* restrict age to be >=25 because we're interested in completed educ    */
/* guarantee that individuals report self-assessed health for themselves */

keep if astatflg==1

keep if  racerec==1 & origin==2
keep if age>=25

gen ind_work = doinglw ==1
replace ind_work =. if doinglw>=7
label var ind_work "=1 if majoractivity/doinglw=working"


replace age = 85 if age>=85 & age!=.

tab educ, mis
gen edclass=.
replace edclass=1 if educ>=0 & educ<=13
replace edclass=2 if educ>=14 & educ<=17
replace edclass=3 if educ>=18 & educ<=21

label def edlab 1 "LT or HS" 2 "Some Coll" 3 "4 Year College+"
label val edclass edlab
label var edclass "Educ category"

save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015, replace

/*************************** 1998 ***************************************************/
use c:\users\accase\dropbox\nhis_alice\infiles\personsx1998.dta

/* keep variables we want */

keep srvy_yr hhx fmx px age_p sex  racerec origin educ doinglw phstat plawklim astatflg region  wtfa ernyr_p

ren srvy_yr year
label drop pep002x

ren age_p age

replace year = 1998
ren phstat   hstat

/* restrict the sample:                                                  */
/* white non-hispanics ages 25+ who responded entirely for themselves    */
/* restrict age to be >=25 because we're interested in completed educ    */
/* guarantee that individuals report self-assessed health for themselves */

keep if astatflg==1

keep if  racerec==1 & origin==2
keep if age>=25

gen ind_work = doinglw ==1
replace ind_work =. if doinglw>=7
label var ind_work "=1 if majoractivity/doinglw=working"


replace age = 85 if age>=85 & age!=.


tab educ, mis

gen edclass=.
replace edclass=1 if educ>=0 & educ<=14
replace edclass=2 if educ>=15 & educ<=17
replace edclass=3 if educ>=18 & educ<=21

label def edlab 1 "LT or HS" 2 "Some Coll" 3 "4 Year College+"
label val edclass edlab
label var edclass "Educ category"

append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015
        save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015, replace

/*************************** 1999 ***************************************************/
use c:\users\accase\dropbox\nhis_alice\infiles\personsx1999.dta

/* keep variables we want */

keep srvy_yr hhx fmx px age_p sex  racerecr origin educ doinglw phstat plawklim astatflg region  wtfa ernyr_p

ren racerecr racerec
ren srvy_yr year
label drop pep002x

ren age_p age

replace year = 1999
ren phstat   hstat

/* restrict the sample:                                                  */
/* white non-hispanics ages 25+ who responded entirely for themselves    */
/* restrict age to be >=25 because we're interested in completed educ    */
/* guarantee that individuals report self-assessed health for themselves */

keep if astatflg==1

keep if  racerec==1 & origin==2
keep if age>=25

gen ind_work = doinglw ==1
replace ind_work =. if doinglw>=7
label var ind_work "=1 if majoractivity/doinglw=working"


replace age = 85 if age>=85 & age!=.


tab educ, mis

gen edclass=.
replace edclass=1 if educ>=0 & educ<=14
replace edclass=2 if educ>=15 & educ<=17
replace edclass=3 if educ>=18 & educ<=21

label def edlab 1 "LT or HS" 2 "Some Coll" 3 "4 Year College+"
label val edclass edlab
label var edclass "Educ category"

append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015
        save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015, replace


/*************************** 2000- 2002 ***************************************************/
forval t = 0(1)2 {
use c:\users\accase\dropbox\nhis_alice\infiles\personsx200`t'.dta

/* keep variables we want */

keep srvy_yr hhx fmx px age_p sex  racrec_i origin_i educ  doinglw phstat plawklim astatflg region  wtfa ernyr_p

ren srvy_yr year
label drop pep002x

replace year = 200`t'

ren age_p    age
ren phstat   hstat
ren racrec_i racerec

/* restrict the sample:                                                  */
/* white non-hispanics ages 25+ who responded entirely for themselves    */
/* restrict age to be >=25 because we're interested in completed educ    */
/* guarantee that individuals report self-assessed health for themselves */

keep if astatflg==1

keep if  racerec==1 & origin_i==2
keep if age>=25


gen ind_work = doinglw ==1
replace ind_work =. if doinglw>=7
label var ind_work "=1 if majoractivity/doinglw=working"


replace age = 85 if age>=85 & age!=.

tab educ, mis

gen edclass=.
replace edclass=1 if educ>=0 & educ<=14
replace edclass=2 if educ>=15 & educ<=17
replace edclass=3 if educ>=18 & educ<=21

label def edlab 1 "LT or HS" 2 "Some Coll" 3 "4 Year College+"
label val edclass edlab
label var edclass "Educ category"

append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015
        save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015, replace
}



/*************************** 2003  ***************************************************/
use c:\users\accase\dropbox\nhis_alice\infiles\personsx2003.dta

/* keep variables we want */

keep srvy_yr hhx fmx px age_p sex  racreci2 origin_i educ  doinglw phstat plawklim astatflg region wtfa ernyr_p

ren srvy_yr year
label drop pep002x

replace year = 2003

ren age_p    age
ren phstat   hstat
ren racreci2 racerec

/* restrict the sample:                                                  */
/* white non-hispanics ages 25+ who responded entirely for themselves    */
/* restrict age to be >=25 because we're interested in completed educ    */
/* guarantee that individuals report self-assessed health for themselves */

keep if astatflg==1

keep if  racerec==1 & origin_i==2
keep if age>=25

gen ind_work = doinglw ==1
replace ind_work =. if doinglw>=7
label var ind_work "=1 if majoractivity/doinglw=working"


replace age = 85 if age>=85 & age!=.

tab educ, mis
gen edclass=.
replace edclass=1 if educ>=0 & educ<=14
replace edclass=2 if educ>=15 & educ<=17
replace edclass=3 if educ>=18 & educ<=21

label def edlab 1 "LT or HS" 2 "HS or Some Coll" 3 "4 Year College+"
label val edclass edlab
label var edclass "Educ category"

append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015
        save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015, replace


/*************************** 2004 ***************************************************/
use c:\users\accase\dropbox\nhis_alice\infiles\personsx2004.dta

/* keep variables we want */

keep srvy_yr hhx fmx fpx age_p sex  racreci2 origin_i educ doinglw phstat plawklim astatflg wtfa ernyr_p

ren srvy_yr year
label drop pep002x

replace year = 2004

ren age_p    age
ren phstat   hstat
ren racreci2 racerec

keep if astatflg==1

keep if  racerec==1 & origin_i==2
keep if age>=25

gen ind_work = doinglw ==1
replace ind_work =. if doinglw>=7
label var ind_work "=1 if majoractivity/doinglw=working"

replace age = 85 if age>=85 & age!=.

tab educ, mis
gen edclass=.
replace edclass=1 if educ>=0 & educ<=14
replace edclass=2 if educ>=15 & educ<=17
replace edclass=3 if educ>=18 & educ<=21

label def edlab 1 "LT or HS" 2 "Some Coll" 3 "4 Year College+"
label val edclass edlab
label var edclass "Educ category"

append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015
        save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015, replace



/*************************** 2005 ***************************************************/
use c:\users\accase\dropbox\nhis_alice\infiles\personsx2005.dta

/* keep variables we want */

keep srvy_yr hhx fmx fpx age_p sex  racreci2 origin_i educ  doinglw phstat plawklim astatflg region wtfa ernyr_p

ren srvy_yr year
label drop pep002x

replace year = 2005

ren age_p    age
ren phstat   hstat
ren racreci2 racerec

/* restrict the sample:                                                  */
/* white non-hispanics ages 25+ who responded entirely for themselves    */
/* restrict age to be >=25 because we're interested in completed educ    */
/* guarantee that individuals report self-assessed health for themselves */

keep if astatflg==1

keep if  racerec==1 & origin_i==2
keep if age>=25

gen ind_work = doinglw ==1
replace ind_work =. if doinglw>=7
label var ind_work "=1 if majoractivity/doinglw=working"


replace age = 85 if age>=85 & age!=.

tab educ, mis

gen edclass=.
replace edclass=1 if educ>=0 & educ<=14
replace edclass=2 if educ>=15 & educ<=17
replace edclass=3 if educ>=18 & educ<=21

label def edlab 1 "LT or HS" 2 "HS or Some Coll" 3 "4 Year College+"
label val edclass edlab
label var edclass "Educ category"

append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015
        save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015, replace


/*************************** 2006-2009 ***************************************************/
forval t = 6(1)9 {
use c:\users\accase\dropbox\nhis_alice\infiles\personsx200`t'.dta

/* keep variables we want */

keep srvy_yr hhx fmx fpx age_p sex  racreci3 origin_i educ doinglw phstat plawklim astatflg region wtfa ernyr_p

ren srvy_yr year

replace year = 200`t'

ren age_p    age
ren phstat   hstat
ren racreci3 racerec

keep if astatflg==1

keep if  racerec==1 & origin_i==2
keep if age>=25

gen ind_work = doinglw ==1
replace ind_work =. if doinglw>=7
label var ind_work "=1 if majoractivity/doinglw=working"

replace age = 85 if age>=85 & age!=.

tab educ, mis

gen edclass=.
replace edclass=1 if educ>=0 & educ<=14
replace edclass=2 if educ>=15 & educ<=17
replace edclass=3 if educ>=18 & educ<=21

label def edlab 1 "LT HS" 2 "HS or Some Coll" 3 "4 Year College+"
label val edclass edlab
label var edclass "Educ category"

append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015
        save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015, replace
}


/*************************** 2010-2015 ***************************************************/
forval t=0(1)5 {
use c:\users\accase\dropbox\nhis_alice\infiles\personsx201`t'.dta

/* keep variables we want */

keep srvy_yr hhx fmx fpx age_p sex  racreci3 origin_i educ doinglw phstat plawklim astatflg region wtfa ernyr_p

ren srvy_yr year
replace year = 201`t'

ren age_p    age
ren phstat   hstat
ren racreci3 racerec

keep if astatflg==1

keep if  racerec==1 & origin_i==2
keep if age>=25

gen ind_work = doinglw ==1
replace ind_work =. if doinglw>=7
label var ind_work "=1 if majoractivity/doinglw=working"


replace age = 85 if age>=85 & age!=.

tab educ, mis

gen edclass=.
replace edclass=1 if educ>=0 & educ<=14
replace edclass=2 if educ>=15 & educ<=17
replace edclass=3 if educ>=18 & educ<=21

label def edlab 1 "LT or HS" 2 "Some Coll" 3 "4 Year College+"
label val edclass edlab
label var edclass "Educ category"
append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015
        save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015, replace
}


tab sex, m
gen fem = sex==2

/*1997-2013 and 2015 question asked as plawklim=0 if person unable to work */

gen  ind_cantwork=1 if plawklim==0
replace ind_cantwork=0 if plawklim>=1 & plawklim<=2
label var ind_cantwork "plawklim=0"

gen ind_EVG = hstat>=1 & hstat<=2
replace ind_EVG = . if hstat>5
gen ind_FP = hstat>=4 & hstat<=5
replace ind_FP = . if hstat>5

ren educ educp
label var educp "education person file"
ren age agep
label var agep "age person file"
save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\WNHsa_1997_2015, replace

/* now merge with sample adult file for years 1997-2015 and save this file  */

replace fpx = px if fpx=="" & px!=""
ren year srvy_yr
merge 1:1 srvy_yr hhx fmx fpx using c:\users\accase\dropbox\nhis_alice\outfiles\sa.dta
/* _m==2 are for hispanics, and race=black, other */
/* that still leaves 39 cases in the sample adult file -- all from 1997-99 -- that aren't in the person file*/
/* I checked two of these and they both had hispanic origin equal to "don't know" */

drop if _m!=3
drop _m
ren srvy_yr year
compare age agep
drop agep

replace educp = educ1 if educp==. & educ1!=.
replace educp = . if educp>21
compare educp educ
drop educp
label drop adp014x


save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\wnhsa_1997_2015 , replace

log close
