cap log close
cap drop _all
set more off
# delimit ;
log using c:\users\accase\dropbox\brookings\archive\dofiles\graph_fig3_3_4.log, replace;
/* estimating year of birth effects for mortality, morbidity, marriage and labor market outcomes */

/*****************************************************/
/* CPS marriage patterns - men and women             */
/*****************************************************/

use c:\users\accase\dropbox\cepr_march\data\cps_march_inc_8016.dta ;
  keep if wbho==1;
  keep if edclass<=2;
  keep if age>=25 & age<=64;

gen yob = year-age ;
gen YOB = .;


gen nevmar = marstat==5;
replace nevmar=. if marstat==.;

gen notmarr = 1 - married ;

keep  nevmar  notmarr wgt yob age ;
collapse nevmar notmarr [aw=wgt], by(yob age);

save c:\users\accase\dropbox\cepr_march\data\CPS_yob_ed12.dta, replace;



/*****************************************/
/* CPS ORG real wages - men by edclass   */
/*****************************************/

use c:\users\accase\dropbox\cepr_org\data\ORG_rw_sex_ed_7915.dta;
  keep if wbho==1;
  keep if edclass<=2;
  keep if female==0;
  keep if age>=25 & age<=64;

gen yob = year-age ;
gen lnrw = log(rw);
gen Mlnrw = -lnrw;
keep Mlnrw orgwgt  yob age ;

collapse Mlnrw [aw=orgwgt], by(yob age);
save c:\users\accase\dropbox\cepr_march\data\CPS_ORG_yob_ed12.dta, replace;


/*****************************************************/
/* CPS March labor force vars - MEN ONLY by edclass  */
/*****************************************************/


use c:\users\accase\dropbox\cepr_march\data\cps_march_inc_8016.dta ;
  keep if wbho==1;
  keep if edclass<=2;
  keep if female==0;
  keep if age>=25 & age<=64;

gen yob = year-age ;

collapse nilf [aw=wgt], by(yob age);
keep nilf yob age;
save "c:\users\accase\dropbox\cepr_march\data\CPS_yob_LFMen_ed12.dta", replace;



/*****************************************/
/*****   BRFSS vars       ****************/
/*****************************************/

tempfile tempdat;
use c:\users\accase\dropbox\brookings\archive\brfss\data\combinebrfs;

   keep if edclass<=2;
   keep if age>=25 & age<=64;

gen yob = year-age;
gen indOB = BMI>30 & BMI!=.;
replace indOB = . if BMI==.;
keep BMI ind_RFDR indOB A_F yob age ;

collapse BMI ind_RFDR indOB [aw=A_F], by(yob age);
save c:\users\accase\dropbox\brfss\data\BRFSS_yob_ed12.dta, replace;

/*****************************************/
/*****   NHIS pain vars by ed **************/
/*****************************************/

use c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\wnhsa_1997_2015_addlvars.dta;
keep if year>=1997 & year<=2015;
keep if edclass<=2;
keep if age>=25 & age<=64;


gen yob = year-age;
gen ind_K6R = K6R>=13;
replace ind_K6R=. if K6R==.;
keep ind_painsci ind_K6R ind_chrjnt ind_paineck ind_painface  ind_flsoc ind_flrelax wtfa_sa yob age;
collapse  ind_painsci ind_K6R ind_chrjnt ind_paineck ind_painface  ind_flsoc ind_flrelax [aw= wtfa_sa], by(yob age);

save c:\users\accase\dropbox\anne_nhis\data\NHIS_yob_ed12.dta, replace;



/*****************************************/
/*****   NVSS mortality ******************/
/*****************************************/

use c:\AAmortality102716\outfiles\WNHrates_SY_MF_2564_ed12_9215 ;
/* these are WNH men and women by yob edclass 1 and 2, ages 25 to 64 */

gen PSLrate = Prate+Srate+Lrate ;
gen yob= year-age;

keep if age>=25 & age<=64;


/*******************************************************/
/**********   Now merge these data sets by YOB   *******/
/*******************************************************/

merge 1:1 yob age using "c:\users\accase\dropbox\anne_nhis\data\NHIS_yob_ed12.dta" ;
drop _m;

merge 1:1 yob age using "c:\users\accase\dropbox\brfss\data\BRFSS_yob_ed12.dta";
drop _m;

merge 1:1 yob age using "c:\users\accase\dropbox\cepr_march\data\CPS_yob_ed12.dta" ;
drop _m;

merge 1:1 yob age using "c:\users\accase\dropbox\cepr_march\data\CPS_yob_LFMen_ed12.dta" ;
drop _m;

merge 1:1 yob age using "c:\users\accase\dropbox\cepr_march\data\CPS_ORG_yob_ed12.dta";
drop _m;


/* this is for Figure 3.3A 3.3B and Figure 3.4 */
keep if yob>=1940 & yob<=1988;
keep if age>=25 & age<=64;

foreach var in Prate Srate Lrate Mlnrw nilf nevmar notmar BMI indOB ind_RFDR ind_K6R ind_painsci ind_chrjnt ind_flsoc ind_flrelax {;
reg `var'  i.age i.yob ;

matrix aa = e(b);
matrix yob_eff=J(49,2,0);
local ic=2;
forvalues j=1941(1)1988 {;
        matrix yob_eff[`ic',1]=aa[1,"`j'.yob"];
        matrix yob_eff[`ic',2]=`j';
        local ic=`ic'+1;
};
matrix yob_eff[1,2]=1940;
svmat yob_eff;
ren yob_eff1 `var'yob ;
ren yob_eff2 `var'yobY;
};


/* Figure 3.3 */

*gr two (line  Prateyob        PrateyobY, yaxis(2)  lwidth(thick) lcolor(red))
       (line  nevmaryob       nevmaryobY,    lwidth(thick) lcolor(blue) )
       (line  notmaryob       notmaryobY,    lwidth(thick) lcolor(midblue) )
       (line  nilfyob         nilfyobY,      lwidth(thick) lcolor(midgreen))
       , graphregion(color(white)) xtitle(year of birth) legend(off) yline(0,lpattern(dot))
       title("less than BA", size(med) color(black))  ysize(4.5) xsize(4)
       saving(c:\users\accase\dropbox\brookings\archive\figures\fig3_3B.gph, replace);

*gr two (line  Srateyob        SrateyobY, yaxis(2)  lwidth(thick) lcolor(blue))
       (line  ind_K6Ryob      ind_K6RyobY,      lwidth(thick) lcolor(midblue))
       (line  ind_RFDRyob        ind_RFDRyobY,  lwidth(thick) lcolor(green) lpattern(longdash))
       (line  ind_flsocyob    ind_flsocyobY,    lwidth(thick) lcolor(orange) lpattern(longdash))
       (line  ind_painsciyob  ind_painsciyobY,  lwidth(thick) lcolor(midgreen))
       (line  ind_chrjntyob   ind_chrjntyobY,   lwidth(thick) lcolor(teal) lpattern(longdash))
       , graphregion(color(white)) xtitle(year of birth) legend(off) yline(0,lpattern(dot))
       title("less than BA", size(med) color(black))  ysize(4.5) xsize(4)
       saving(c:\users\accase\dropbox\brookings\archive\figures\fig3_3A.gph, replace);


/* Figure 3.4 */
gr two (line  Mlnrwyob     MlnrwyobY,     lwidth(thick) lcolor(red) lpattern(longdash))
       (line  nilfyob      nilfyobY ,     lwidth(thick) lcolor(blue) lpattern(longdash))
       , graphregion(color(white)) xtitle(year of birth) legend(off) yline(0,lpattern(dot))
       title("Figure 3.4 Log wages and labor force participation, white non-Hispanic men, less than BA", size(med) color(black))  ysize(4.5) xsize(4)
       saving(c:\users\accase\dropbox\brookings\archive\figures\fig3_4.gph, replace);

log close; stop;
