cap log close
cap drop _all
set more off
# delimit ;
log using c:\users\accase\dropbox\cepr_march\dofiles\graph_fig2_3.log , replace;


use  ..\data\cps_march_inc_8016.dta ;
*drop if year==2016;


bysort year hhseq: egen hhsize = count(perno);
gen rypc = rinch_all/hhsize ;

/* keep one observation per household */
keep if one==1;
keep if Hwbho<=2;


gen Hedclass=1 if Heduc<3;
replace Hedclass=2 if Heduc==3;
replace Hedclass=3 if Heduc>3 & Heduc!=.;



keep if Hage>=45 & Hage<=54;

ren Hwbho race;

collapse (median) medrypc=rypc  [aw=hhwgt], by(year race Hedclass) ;
ren Hedclass edclass;

*gr two (line medrypc year if race==1 & edclass==1, yaxis(2) lcolor(blue))
       (line medrypc year if race==2 & edclass==1, lcolor(red))
       , legend(off) title(Median income per household member, size(med) color(black)) xtitle(year)
        graphregion(color(white))
        subtitle("Householders ages 45-54, high school or less");


gr two (line medrypc year if race==1 & edclass==3, yaxis(2) lcolor(blue))
       (line medrypc year if race==2 & edclass==3, lcolor(red))
       , legend(off) title(Median income per household member, size(med) color(black)) xtitle(year)
        graphregion(color(white))
        subtitle("Householders ages 45-54, BA or more");
log close;
stop;
