cap log close
cap drop _all
set more off
# delimit ;
log using "c:\users\accase\dropbox\mortality by cause by country by year\dofiles\graph_fig1_4.log" , replace;

use "c:\users\accase\dropbox\mortality by cause by country by year\finalfiles9_10_update\rates\intl_rates_5yr.dta" ;

gen inEUR = iso=="AUS"|iso=="CAN"|iso=="FRA"|iso=="GER"|iso=="UK"|iso=="SWE" ;
gen lnT=log(Trate);
gen lnH=log(Hrate);
gen lnPSL = log(PSLrate);
gen lnP=log(Prate);
gen lnS=log(Srate);

keep if sex==0;
keep if age>=30 & age<=60;

gen USWcoef=.;
gen USBcoef=.;
gen USHcoef=.;
gen EURcoef=.;
gen YR=.;
gen AG=.;

local i = 1;

keep if year>=1990;
drop if year==.;
gen ge00 = year>=2000;
encode iso, gen(ISO);

forval j=30(5)60 {;
forval k = 0(1)1 {;

dis "USW age=`j' yr=`k'"   ;
reg lnT year if age==`j' & ge00==`k' & iso=="USW";
replace USWcoef=_b[year] in `i' ;

dis "USB age=`j' yr=`k'"   ;
reg lnT year if age==`j' & ge00==`k' & iso=="USB";
replace USBcoef=_b[year] in `i' ;

dis "USH age=`j' yr=`k'"   ;
reg lnT year if age==`j' & ge00==`k' & iso=="USH";
replace USHcoef=_b[year] in `i' ;

dis "EUR age=`j' yr=`k'"   ;
reg lnT year i.ISO if age==`j' & ge00==`k' & inEUR==1;
replace EURcoef=_b[year] in `i' ;
replace YR = `k' in `i';
replace AG = `j' in `i';
local i = `i'+1;
};
};
gen AGYR = AG*10+YR;
gr bar USWcoef USBcoef EURcoef if YR==1, over(AG) legend(off) graphregion(color(white))
title("Mortality trends 2000-2014 by five year age group", size(medlarge) color(black))
subtitle("US white- and black-non Hispanics and comparison countries", size(medsmall))
note("Comparison countries: AUS, CAN, FRA, GER, UK, SWE") ;

log close;
stop;
