cap log close
cap drop _all
set more off
# delimit ;
log using c:\users\accase\dropbox\cepr_march\dofiles\graph_fig2_2B.log, replace;


use c:\aamortality102716\outfiles\wnhrates_sex_5yr_state_ed_9215.dta;
keep if age_gp>=30 & age_gp<=60;
keep if sex==0;

gen lnT = log(Trate);

reg lnT  i.age i.year if  edclass==1  ;
margins year, post;
estimates store year_ed1_sex0 ;

reg lnT i.age i.year if  edclass==2   ;
margins year, post;
estimates store year_ed2_sex0 ;

reg lnT i.age i.year if  edclass==3   ;
margins year, post;
estimates store year_ed3_sex0 ;

label var year " ";

coefplot (year_ed1_sex0, label(LEHS)) (year_ed2_sex0, label(SomeCol)) (year_ed3_sex0, label(BA)) || , vertical noci
title(All-cause mortality year margins, size(medlarge) color(black))
subtitle(white non-Hispanic men and women ages 30-64)  xtitle(year) legend(off) graphregion(color(white))
note("age-adjusted year effects from regressions of log(mortality rate) on year and age indicators, by education");


log close;
stop;
