cap log close
cap drop _all
set more off
# delimit ;

tempfile tempW1;
tempfile tempintl ;

log using graph_Fig1_3A.log, replace ;

/* must first download HMD 1x1 Trates made using c:\users\accase\dropbox\HMD\dofiles\make_trate_1x1_update.do */

use c:\users\accase\dropbox\hmd\data\Trate_1x1_update.dta;
keep year iso sex age Tmort Population ;
keep if sex==0;  drop sex;
keep if year>=1989;
keep if age>=45 & age<=54;
bysort iso year: egen TOTDeath = total(Tmort);
bysort iso year: egen TOTPop = total(Population);
gen Trate = TOTDeath*100000/TOTPop;
/* drop when series ends */
drop if Trate==0;
bysort iso year: keep if _n==1;
keep iso year Trate;
ren iso isocode;
gen sex=0;
gen age=45;


label var age "ages 45-54";
keep year age sex isocode Trate;
save `tempintl' ;


/**********************************************/
/****** US WNH ages 45-54 not age adjusted ****/
/**********************************************/

/* the first file  comes directly from CDC bridged-race population website */
  use c:\aamortality102716\outfiles\wnh_pop_4554_9015.dta;
  gen year = real(Yearly_July_1st_Estimates_Code);
  keep if year>=1990 & year<=2015;
  keep year Population;
save `tempW1';

/*  count overall death by year for WNH   */

use "c:\aamortality102716\outfiles\mort_8915";
keep if age>=45 & age<=54;
keep if race==1;

keep  year  ;
keep if year>=1990 & year<=2015;
gen one=1;
bysort year : egen Tmort  = total(one);
by year, sort:  keep if _n==1;

merge 1:1 year using `tempW1' ;

gen Trate = Tmort*100000/Population;
keep year Trate ;
gen sex=0;
gen isocode = "USW";
gen age=45;
label data "WNH Trate 45-54 both sexes";

merge 1:1 year age sex isocode using `tempintl';
drop _m;
reshape wide Trate, i(year age sex) j(isocode) str;

graph two line Trate* year, legend(off) graphregion(color(white)) ysize(4.0) xsize(3.5)
       ytitle("deaths per 100,000") xtitle(year) title("All-cause mortality rates", color(black) size(medlarge));

log close;
stop;


