cap log close
cap drop _all
set more off
# delimit ;
log using c:\users\accase\dropbox\brookings\archive\dofiles\graph_fig1_13.log, replace;
use c:\users\accase\dropbox\brookings\archive\nhis\dofiles\sample_adult\outfiles\wnhsa_1997_2015_addlvars;

gen yob = year-age;
gen YOB = 1940 if yob>=1940 & yob<=1942 ;
forval i = 1950(10)1980 {;
replace YOB = `i' if yob>=`i' & yob<=`i'+2 ;
};

keep if YOB!=.;
keep if age<=75;
sum age, det;

forval i = 1940(10)1980 {;
dis "   ";
dis "birth cohort `i' edclass 1-2";
sum ind_painsci if edclass<3 & YOB==`i';
dis "  ";
dis "birth cohort `i' edclass 3";
sum ind_painsci if edclass==3 & YOB==`i';
};


*gr two (lpoly ind_painsci age if YOB==1940 & edclass<3 [aw=wtfa_sa], lcolor(blue) lwidth(thick))
       (lpoly ind_painsci age if YOB==1950 & edclass<3 [aw=wtfa_sa], lcolor(purple) lwidth(thick) lpattern(longdash))
       (lpoly ind_painsci age if YOB==1960 & edclass<3 [aw=wtfa_sa], lcolor(midgreen) lwidth(thick) )
       (lpoly ind_painsci age if YOB==1970 & edclass<3 [aw=wtfa_sa], lcolor(midblue) lwidth(thick) lpattern(longdash) )
       (lpoly ind_painsci age if YOB==1980 & edclass<3 [aw=wtfa_sa], lcolor(red) lwidth(thick) ),
    graphregion(color(white)) legend(off) xtitle(age) ytitle(fraction reporting) title(less than BA, size(medlarge) color(black))
    saving(c:\users\accase\dropbox\brookings\archive\figures\fig1_13A.gph, replace) ;



*gr two (lpoly ind_painsci age if YOB==1940 & edclass==3 [aw=wtfa_sa], lcolor(blue) lwidth(thick))
       (lpoly ind_painsci age if YOB==1950 & edclass==3 [aw=wtfa_sa], lcolor(purple) lwidth(thick) lpattern(longdash))
       (lpoly ind_painsci age if YOB==1960 & edclass==3 [aw=wtfa_sa], lcolor(midgreen) lwidth(thick) )
       (lpoly ind_painsci age if YOB==1970 & edclass==3 [aw=wtfa_sa], lcolor(midblue) lwidth(thick) lpattern(longdash) )
       (lpoly ind_painsci age if YOB==1980 & edclass==3 [aw=wtfa_sa], lcolor(red) lwidth(thick) ),
    graphregion(color(white)) legend(off) xtitle(age) ytitle(fraction reporting) title(BA or more, size(medlarge) color(black))
    ylabel(.05 .1 .15 .2)
    saving(c:\users\accase\dropbox\brookings\archive\figures\fig1_13B.gph, replace) ;

log close;
