set more off
cap drop _all
cap log close
# delimit ;
tempfile tempdat;
log using graph_Fig1_1.log, replace;

use c:\aamortality102716\outfiles\WNHrates_sex_5yr_state_ed_9215.dta;
keep year age sex edclass Trate ;
gen race=1;
reshape wide Trate, i(year race age sex) j(edclass);
/* note: Trate1 is all-cause mortality for WNH with a high school degree or less education */

/* merge mortality rates by education group with 5-year age group mortality rates by race and sex from CDC Wonder */
merge 1:1 year race age sex using c:\users\accase\dropbox\acs\data\cdc_9915_5yr_sex\data\WNH_BNH_Trate_5yr_sex ;
drop _m;

/***************************************************************/
/**** Figure 1.1  Brookings *****************/
keep if age==50 ;
keep if sex==0;

drop if year<1999;
gr two (sc Trate year if race==1,   color(blue))
       (sc Trate year if race==2,   color(navy))
       (sc Trate year if race==3,   color(midblue))
       (sc Trate1 year if race==1,  color(red))
       (line Trate year if race==1, lcolor(blue) lwidth(medthick))
       (line Trate year if race==3, lcolor(midblue) lwidth(medthick))
       (line Trate year if race==2, lcolor(navy) lwidth(medthick))
       (line Trate1 year if race==1, lcolor(red) lwidth(medthick)),
  legend(off) ytitle("deaths per 100,000") title("All-cause mortality by race and ethnicity, ages 50-54", color(black) size(med))
  ylabel(300 500 700 900) yline(500 700 900) graphregion(color(white));
*saving(c:\users\accase\dropbox\acs\data\brookings\results\Fig1_1.gph, replace);


log close; stop;
