cap log close
cap drop _all
set more off
log using make_CPS_March_incdata_0016.log, replace
# delimit ;
/* combining March cps data on incomes 2000-16  */
/* we will do this for 1980-89 and 1990-99 but in batches */

tempfile tempbig;

use c:\users\accase\dropbox\cepr_march\data\cepr_march_2000 ;
   keep month state mis hhid hhseq perno year age id famno famhh famtyp p*fam research st*yr female *wgt r*all female educ
   married marstat empl unem nilf csr centcity
   suburb rural occly* rhr* dis* relhdh* wbho state  ;
   save `tempbig';


forval i = 2001 (1) 2016 {;
  use "c:\users\accase\dropbox\cepr_march\data\cepr_march_`i'.dta" ;
   keep month state mis hhid hhseq perno year age id famno famhh famtyp p*fam research st*yr female *wgt r*all female educ
   married marstat empl unem nilf csr centcity
   suburb rural occly* rhr* dis* relhdh* wbho state  ;
  append using `tempbig';
  save `tempbig', replace;
};


gen edclass=1 if educ<=2;
replace edclass=2 if educ==3;
replace edclass=3 if educ>=4 & educ<=5 ;
label def edlab 1 LEHS 2 SomeC 3 College;
label val edclass edlab;
label var edclass "LEHS SomeC College";

save c:\users\accase\dropbox\cepr_march\data\cps_march_incdata_0016.dta, replace;

log close;
stop;

