version 13.1
#delimit ;
clear;
set logtype text;
*cap log close;
*cd "C:\Users\accase\Dropbox\Mortality by cause by country by year";
*log using dofiles\process_pop.log, replace;

tempfile temp;
use infiles/age_cats_males_females_both.dta;
*just keep the countries we want;
   keep if inlist(countrycode,36,124,250,276,752,826,840,620,372,300,724,392,380,246,40,56,191,
   203,233,246,348,352,528,578,616,756,703,705,100,196,440,442,428,470,642,208);

*keep if year >=1990;
rename countrycode UN_country_code;
save `temp', replace;

use infiles/un_who_crosswalk;

sort UN_country_code;

merge 1:m UN_country_code using `temp';

keep if _m==3; drop _m;
sort UN_country_code;



rename WHO_country_code country;
sort country year sex;
save `temp', replace;

merge 1:1 country year sex using outfiles/alldeathsicd9_10_update.dta;


	do dofiles\create_rates.do;
save finalfiles9_10_update\alldeathsicd9_10_pop, replace;

clear;
use `temp';
merge 1:1 country year sex using outfiles\cancericd9_10_update.dta;
	do dofiles\create_rates.do;
save finalfiles9_10_update/cancericd9_10_pop, replace;

clear;
use `temp';
merge 1:1 country year sex using outfiles/hearticd9_10_update.dta;
	do dofiles\create_rates.do;
save finalfiles9_10_update/hearticd9_10_pop, replace;

clear;
use `temp';
merge 1:1 country year sex using outfiles/diabetesicd9_10_update.dta;
	do dofiles\create_rates.do;
save finalfiles9_10_update/diabetesicd9_10_pop, replace;



clear;
use `temp';
merge 1:1 country year sex using outfiles/livericd9_10_update.dta;
	do dofiles\create_rates.do;
save finalfiles9_10_update/livericd9_10_pop, replace;

clear;
use `temp';
merge 1:1 country year sex using outfiles/lungCicd9_10_update.dta;
	do dofiles\create_rates.do;
save finalfiles9_10_update/lungCicd9_10_pop, replace;

clear;
use `temp';
merge 1:1 country year sex using outfiles/poisonicd9_10_update.dta;
	do dofiles\create_rates.do;
save finalfiles9_10_update/poisonicd9_10_pop, replace;

clear;
use `temp';
merge 1:1 country year sex using outfiles/suicideicd9_10_update.dta;
	do dofiles\create_rates.do;
save finalfiles9_10_update/suicideicd9_10_pop, replace;



clear;
*log close;


