cap log close
set more off
cap drop _all
log using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\make_WNHsa_1997_2015_addlvars.log, replace

******  adding additional health variables to the sample adult file we use  ****
/*      data required: samadult1997.dta-samadult2015.dta  ******************** */

/*************************** 1997 ***************************************************/
use c:\users\accase\dropbox\nhis_alice\infiles\samadult1997.dta

/* keep variables we want */

keep srvy_yr hhx fmx px  jntmo jntyr  wrklyr2 wrkcat occup2
ren px fpx
ren occup2 occ
gen workWC = occ>=1 & occ<=5
replace workWC=. if occ>13


save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa1997_addl, replace

/*************************** 1998 - 1999  ***************************************************/
forval t = 98 (1) 99 {
use c:\users\accase\dropbox\nhis_alice\infiles\samadult19`t'.dta

/* keep variables we want */

keep srvy_yr hhx fmx px  jntmo jntyr  wrklyr2 wrkcat occup2 alcndr3
ren px fpx
ren occup2 occ
gen workWC = occ>=1 & occ<=5
replace workWC=. if occ>13


save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa19`t'_addl, replace
}
/*************************** 2000 ***********************************************************/
use c:\users\accase\dropbox\nhis_alice\infiles\samadult2000.dta

/* keep variables we want */

keep srvy_yr hhx fmx px  jntmo jntyr  wrklyr2 wrkcat occup2 alcndr3
ren px fpx
ren occup2 occ
gen workWC = occ>=1 & occ<=5
replace workWC=. if occ>13

save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa2000_addl, replace

/*************************** 2001***********************************************************/

use c:\users\accase\dropbox\nhis_alice\infiles\samadult2001.dta

/* keep variables we want */

keep srvy_yr hhx fmx px  jntmo jntyr  wrklyr3 wrkcat occup2 occup2a arth alcndr3
ren wrklyr3 wrklyr2
ren px fpx
ren occup2 occ
gen workWC = occ>=1 & occ<=5
replace workWC=. if occ>13

save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa2001_addl, replace


/*************************** 2002 - 2003 ***************************************************/
forval t = 2(1)3 {
use c:\users\accase\dropbox\nhis_alice\infiles\samadult200`t'.dta

/* keep variables we want */

keep srvy_yr hhx fmx px  jntchr jntsymp  wrklyr3 wrkcat occup2 occup2a arth1 alchrc3
ren wrklyr3 wrklyr2
ren px fpx
ren occup2 occ
gen workWC = occ>=1 & occ<=5
replace workWC=. if occ>13

save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa200`t'_addl, replace
}

/*************************** 2004 - 2009 ***************************************************/
forval t = 4(1)9 {
use c:\users\accase\dropbox\nhis_alice\infiles\samadult200`t'.dta

/* keep variables we want */

keep srvy_yr hhx fmx fpx  jntchr jntsymp  wrklyr3 wrkcat occupn2 arth1 alchrc3
ren wrklyr3 wrklyr2
/* using just occupn2 - and not occupn2 and occupn2 gave a better match with earlier WC designations (occup2a) - see occ_xwalk.do */
/* NB: this is for people currently working or who EVER worked - we'll have to restrict sample to currently working where appropriate */
gen workWC = occupn2>=1 & occupn2<=11
replace workWC = 1 if occupn2>=16 & occupn2<=17
replace workWC = . if occupn2>=23

save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa200`t'_addl, replace
}

/*************************** 2010 - 2015 ***************************************************/
forval t = 0(1)5 {
use c:\users\accase\dropbox\nhis_alice\infiles\samadult201`t'

/* keep variables we want */

keep srvy_yr hhx fmx fpx  jntchr jntsymp  wrklyr4 wrkcata occupn2 arth1 alchrc3
ren wrklyr4 wrklyr2
rename wrkcata wrkcat

gen workWC = occupn2>=1 & occupn2<=11
replace workWC = 1 if occupn2>=16 & occupn2<=17
replace workWC = . if occupn2>=23

save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa201`t'_addl, replace
}


/*************************** now combine**********************************************/
forval t = 7(1)9{
append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa199`t'_addl
}

forval t=0(1)9 {
append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa200`t'_addl
}

forval t=0(1)4{
append using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa201`t'_addl
}

save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa_addl, replace

gen ind_painjnt     = 1 if jntmo==1
replace ind_painjnt = 0 if jntmo==2
replace ind_painjnt = . if jntmo>2 & jntmo!=.
replace ind_painjnt = 0 if jntyr==2

replace ind_painjnt = 1 if jntchr==1
replace ind_painjnt = 0 if jntchr==2
replace ind_painjnt = . if jntchr>2 & jntchr!=.
replace ind_painjnt = 0 if jntsymp==2

/* questions changed between 2001 and 2002 - create a variable just for 2002-forward */
gen ind_chrjnt = 1 if jntchr==1
replace ind_chrjnt = 0 if jntchr==2
replace ind_chrjnt = . if jntchr>2 & jntchr!=.
replace ind_chrjnt = 0 if jntsymp==2

/* arthritis variables */
gen arthev = 1 if arth ==1
replace arthev = 0 if arth ==2
replace arthev = 1 if arth1 ==1
replace arthev = 0 if arth1 ==2
label var arthev "ever told had arthritis"

gen arthchr = 1 if alcndr3 ==1
replace arthchr = 0 if alcndr3 !=1 & srvy_yr>=1998 & srvy_yr<=2001
replace arthchr = 1 if alchrc3 ==1
replace arthchr = 0 if alchrc3 !=1 & srvy_yr>=2002 & srvy_yr<=2015
label var arthchr "assessed chronic arthitis"
/* NB: in a very small number of cases, status may not be known, but is set =0 here */


ren srvy_yr year
save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa_addl, replace


use c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\sa_addl
/*  merge with sample adult-person file created using make_wnhsa_1997_2015.do, for years 1997-2015 and save this file separately */
merge 1:1 year  hhx fmx fpx using c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\wnhsa_1997_2015.dta
ren occ_now occ_now_SOC2000
ren occ_prev occ_prev_SOC2000

/* this is the number we thought we wouldn't match based on race, hisp and age */
drop if _m==1
drop _m

replace sad = asisad if year>=2013
replace restless = asirstls if year>=2013
replace worthls = asiwthls  if year>=2013
replace effort  = asieffrt  if year>=2013
replace hopeless = asihopls if year>=2013
replace nervous  = asinerv  if year>=2013
ren worthls worthless

/* get a K6 recode to match what CDC does */
foreach var in sad restless worthless effort hopeless nervous {
gen `var'R = 0 if `var'==5
replace `var'R = 1 if `var'==4
replace `var'R = 2 if `var'==3
replace `var'R = 3 if `var'==2
replace `var'R = 4 if `var'==1
}


gen K6 = sad+restless+worthless+effort+hopeless+nervous
label var K6 "Kessler scale 1-5"
tab K6
tab year, sum(K6)

gen K6R = sadR+restlessR+worthlessR+effortR+hopelessR+nervousR
label var K6R "Kessler scale recode"
tab K6R
tab year, sum(K6R)


# delimit ;
/**  ADLs **/
foreach var in flwalk flclimb flstand flsit flstoop flreach flgrasp flcarry flpush flshop flsocl flrelax {;
gen ind_`var'D = `var'>=2 & `var'<=6 ;
replace ind_`var'D= . if `var'>6 ;
};


/* painleg is only for those who report lower back pain */
gen painsci = painleg;
replace painsci = 2 if painlb==2 ;
replace painsci = . if painlb==. ;

/* separate lower back sciatic pain from other lower back pain */
gen painlb_ns = painlb;
replace painlb_ns = 0 if painsci ==1;
tab painlb_ns painsci;
tab painlb_ns painlb;

foreach var in paineck painface painsci   {;
gen ind_`var'= `var'==1;
replace ind_`var'=. if `var'==.;
};

save c:\users\accase\dropbox\brookings\archive\NHIS\dofiles\sample_adult\outfiles\wnhsa_1997_2015_addlvars , replace;

log close ;
