cap log close
cap drop _all
set more off
# delimit ;
log using make_Trate_1x1_update.log,replace;

tempfile tempmort;
tempfile temppop;

/* reading updated mortality for AUS, CAN, FRA, GER_All SWE and UK_All 1x1 files deaths and pop */

/*************/
/* Australia */
/*************/
infile year age D2 D1 D0 using ..\data\aus\deaths_1x1_2017.raw ;
reshape long D, i(year age) j(sex) ;
ren D Tmort;
gen iso="AUS" ;
save `tempmort';

clear;
infile year age Population2 Population1 Population0 using ..\data\aus\Population_2017.raw ;
reshape long Population, i(year age) j(sex) ;
gen iso="AUS" ;
save `temppop';

/*************/
/* Canada    */
/*************/
clear;
infile year age D2 D1 D0 using ..\data\can\deaths_1x1_2017.raw ;
reshape long D, i(year age) j(sex) ;
ren D Tmort;
gen iso="CAN" ;
merge 1:1 year age sex iso using `tempmort';
drop _m;
save `tempmort', replace;

clear;
infile year age Population2 Population1 Population0 using ..\data\can\Population_2017.raw ;
reshape long Population, i(year age) j(sex) ;
gen iso="CAN" ;
merge 1:1 year age sex iso using `temppop';
drop _m;
save `temppop', replace;


/*************/
/* France    */
/*************/
clear;
infile year age D2 D1 D0 using ..\data\fra\deaths_1x1_2017.raw ;
reshape long D, i(year age) j(sex) ;
ren D Tmort;
gen iso="FRA" ;
merge 1:1 year age sex iso using `tempmort';
drop _m;
save `tempmort', replace;

clear;
infile year age Population2 Population1 Population0 using ..\data\fra\Population_2017.raw ;
reshape long Population, i(year age) j(sex) ;
gen iso="FRA" ;
merge 1:1 year age sex iso using `temppop';
drop _m;
save `temppop', replace;



/*********************/
/* Germany - United  */
/*********************/
clear;
infile year age D2 D1 D0 using ..\data\GER_All\deaths_1x1_2017.raw ;
reshape long D, i(year age) j(sex) ;
ren D Tmort;
gen iso="GER" ;
merge 1:1 year age sex iso using `tempmort';
drop _m;
save `tempmort', replace;

clear;
infile year age Population2 Population1 Population0 using ..\data\GER_All\Population_2017.raw ;
reshape long Population, i(year age) j(sex) ;
gen iso="GER" ;
merge 1:1 year age sex iso using `temppop';
drop _m;
save `temppop', replace;


/*********************/
/* Sweden            */
/*********************/
clear;
infile year age D2 D1 D0 using ..\data\SWE\deaths_1x1_2017.raw ;
reshape long D, i(year age) j(sex) ;
ren D Tmort;
gen iso="SWE" ;
merge 1:1 year age sex iso using `tempmort';
drop _m;
save `tempmort', replace;

clear;
infile year age Population2 Population1 Population0 using ..\data\SWE\Population_2017.raw ;
reshape long Population, i(year age) j(sex) ;
gen iso="SWE" ;
merge 1:1 year age sex iso using `temppop';
drop _m;
save `temppop', replace;


/*********************/
/* UK All            */
/*********************/
clear;
infile year age D2 D1 D0 using ..\data\UK_All\deaths_1x1_2017.raw ;
reshape long D, i(year age) j(sex) ;
ren D Tmort;
gen iso="UK" ;
merge 1:1 year age sex iso using `tempmort';
drop _m;
save `tempmort', replace;
save c:\users\accase\dropbox\HMD\data\Tmort_1x1_update.dta, replace;

clear;
infile year age Population2 Population1 Population0 using ..\data\UK_All\Population_2017.raw ;
reshape long Population, i(year age) j(sex) ;
gen iso="UK" ;
merge 1:1 year age sex iso using `temppop';
drop _m;
save `temppop', replace;
save c:\users\accase\dropbox\HMD\data\Pop_1x1_update.dta, replace;

keep if year>=1980 & year!=.;
keep if age>=25 & age<=69 ;
save `temppop', replace ;


use c:\users\accase\dropbox\HMD\data\Tmort_1x1_update.dta ;
keep if year>=1980 & year!=.;
keep if age>=25 & age<=69 ;
merge 1:1 year age sex iso using `temppop' ;
gen Trate_SY = (Tmort *100000)/Population;
drop _merge;

save c:\users\accase\dropbox\HMD\data\Trate_1x1_update.dta, replace;

log close;

