cap log close
cap drop _all
set more off
# delimit ;
log using graph_fig3_2.log , replace ;


/* creating variables from March CPS 1980-2016 */
/* to graph percent never married by birth year and age */
/* Figure 3.2 */


use c:\users\accase\dropbox\cepr_march\data\cps_march_inc_8016.dta ;

/* WNH MEN AND WOMEN */
keep if wbho==1;
keep if age>=25 & age<=64;

gen EDCL=1 if edclass>=1 & edclass<=2;
replace EDCL=3 if edclass==3 ;

gen nevmar = marstat==5;
replace nevmar=. if marstat==.;

gen yob = year-age ;

keep if yob>=1940 & yob<=1980 ;

gen YOB = 1940 if yob==1940;

forval i = 1950(10) 1980 {;
replace YOB = `i' if yob==`i' ;
};

keep if YOB!=.;

/* just to get cell counts */
tab YOB if EDC==1, sum(nevmar);
tab YOB if EDC==3, sum(nevmar);

forval i = 1930(10)1980 {;
dis "EDC 1 YOB `i'";
sum age if EDC==1 & YOB==`i';
};



collapse   nevmar  [aw=wgt], by(YOB EDC age );

gen pct_nmar = nevmar*100;


gr two (line pct_nmar age if YOB==1940  & EDC==1  , lcolor(blue) lwidth(thick))
       (line pct_nmar age if YOB==1950  & EDC==1  , lwidth(thick)  lpattern(longdash))
       (line pct_nmar age if YOB==1960  & EDC==1  , lcolor(midgreen) lwidth(thick))
       (line pct_nmar age if YOB==1970  & EDC==1  , lcolor(orange) lwidth(thick) lpattern(longdash))
       (line pct_nmar age if YOB==1980  & EDC==1  , lwidth(thick) lcolor(red)),
  xlabel(30 40 50 60)
  ylabel(0 20 40 60)
  graphregion(color(white)) legend(off) title(less than BA) ytitle(percent never married)
  saving(c:\users\accase\dropbox\brookings\results\fig3_2A.gph, replace);


gr two (line pct_nmar age if YOB==1940  & EDC==3  , lcolor(blue) lwidth(thick))
       (line pct_nmar age if YOB==1950  & EDC==3  , lwidth(thick)  lpattern(longdash))
       (line pct_nmar age if YOB==1960  & EDC==3  , lcolor(midgreen) lwidth(thick))
       (line pct_nmar age if YOB==1970  & EDC==3  , lcolor(orange) lwidth(thick) lpattern(longdash))
       (line pct_nmar age if YOB==1980  & EDC==3  , lwidth(thick) lcolor(red)),
  xlabel(30 40 50 60)
  ylabel(0 20 40 60)
  graphregion(color(white)) legend(off) title(BA or more) ytitle(percent never married)
  saving(c:\users\accase\dropbox\brookings\results\fig3_2B.gph, replace);

log close ; stop;
