cap log close
cap drop _all
set more off
# delimit ;
log using c:\aamortality102716\dofiles\graph_fig2_2A.log, replace;


use "c:\users\accase\dropbox\cepr_march\data\stcross.dta";
ren State state;
merge 1:m  state using c:\users\accase\dropbox\cepr_march\data\cps_march_inc_8016.dta ;
drop _m;
drop if year==2016;

/* drop states that don't have education on death certificates */
/* and keep records from 1992 on to use in education work */
  drop if year<1992;
  drop if (fipsstr==13|fipsstr==40|fipsstr==44|fipsstr==46);


bysort year hhseq: egen hhsize = count(perno);
gen rypc = rinch_all/hhsize ;

/* keep one member per household */
keep if one==1;
/* householder is white */
keep if Hwbho==1;


gen Hedclass=1 if Heduc<3;
replace Hedclass=2 if Heduc==3;
replace Hedclass=3 if Heduc>3 & Heduc!=.;



    gen Hage_gp=30 if Hage>=30 & Hage<=34;
replace Hage_gp=35 if Hage>=35 & Hage<=39;
replace Hage_gp=40 if Hage>=40 & Hage<=44;
replace Hage_gp=45 if Hage>=45 & Hage<=49;
replace Hage_gp=50 if Hage>=50 & Hage<=54;
replace Hage_gp=55 if Hage>=55 & Hage<=59;
replace Hage_gp=60 if Hage>=60 & Hage<=64;
drop if Hage==.;

ren Hwbho race;

collapse (median) medrypc=rypc  [aw=hhwgt], by(year race Hage_gp Hedclass);
gen lnmedrypc = log(medrypc);

ren Hedclass edclass;
ren Hage_gp age_gp;

reg lnmedrypc i.age i.year if  edclass==1 & age>=30 & age<=60 ;
margins year, post;
estimates store year_ed1_sex0 ;

reg lnmedrypc i.age i.year if  edclass==2 & age>=30 & age<=60 ;
margins year, post;
estimates store year_ed2_sex0 ;

reg lnmedrypc i.age i.year if  edclass==3 & age>=30 & age<=60;
margins year, post;
estimates store year_ed3_sex0 ;

label var year " ";

coefplot (year_ed1_sex0, label(LEHS)) (year_ed2_sex0, label(SomeCol)) (year_ed3_sex0, label(BA)) || , vertical noci
title(All-cause mortality year margins, size(medlarge) color(black))
subtitle(white non-Hispanic men and women ages 30-64)  xtitle(year) legend(off) graphregion(color(white))
note("age-adjusted year effects from regressions of log(median income per member) on year and age indicators, by education");


log close;
stop;
