cap log close
cap drop _all
set more off
# delimit ;
log using c:\aamortality102716\dofiles\graph_fig2_1.log, replace;

/*********************************************************************************************************/
/*** calculate all-cause mortality rates for WNH for two 5-year ages (50-54 and 65-59) group 1990-2015 ***/
/*********************************************************************************************************/

tempfile tempmort ;
use c:\aamortality102716\outfiles\mort_8915.dta ;
  keep if year>=1990;
  keep if ind_WNH==1;
  keep if (age_gp==50|age_gp==65);
  keep year age_gp ;

gen one=1;
bysort year age_gp: egen Tmort_A = total(one);
bysort year age_gp: keep if _n==1;

keep year age_gp Tmort_A;
save `tempmort';

/* the following is a population dataset from CDC bridged-race population */
/* for white non-Hispanics, by 5-year age group, by sex, for years 1990-2015 */
use c:\users\accase\dropbox\USCounties\population\bridge_pop\WNH_pop_5yr_sex_9015_prepped ;
  drop if year==.;
  isid year age_gp sex;

bysort year age_gp: egen TPOP = total(population);
bysort year age_gp: keep if _n==1;
keep year age_gp TPOP;

merge 1:1 year age_gp using `tempmort';
keep if _m==3;
drop _m;

tab age_gp;
gen Trate_A = Tmort_A*100000/TPOP;
keep year age_gp Trate_A;
save `tempmort', replace;


tempfile tempdat;

use c:\users\accase\dropbox\cepr_march\data\cps_march_inc_8016.dta ;
drop if year<1990;

bysort year hhseq: egen hhsize = count(perno);
gen rypc = rinch_all/hhsize ;

keep if one==1;
keep if Hwbho==1;

    gen Hage_gp=50 if Hage>=50 & Hage<=54;
replace Hage_gp=65 if Hage>=65 & Hage<=69;
drop if Hage==.;


collapse (median) medrypc=rypc (median) medrinc=rinch_all  [aw=hhwgt], by(year Hage_gp);

ren Hage_gp age_gp;
drop if age_gp==.;
isid year age_gp;
merge year age_gp using `tempmort' ;

*gr two (line medrypc year if age==50, lcolor(blue) lwidth(medthick) )
       (line Trate_A year if age==50, lcolor(red) lwidth(medthick) lpattern(longdash) yaxis(2))
       , legend(off) graphregion(color(white)) title(ages 50-54, size(medlarge)) ;


gr two (line medrypc year if age==65, lcolor(blue) lwidth(medthick) )
       (line Trate_A year if age==65, lcolor(red) lwidth(medthick) lpattern(longdash) yaxis(2))
       , legend(off) graphregion(color(white)) title(ages 50-54, size(medlarge)) ;
log close;

