cap log close
cap drop _all
set more off
# delimit ;

tempfile tempdat;
tempfile tempW1;
log using graph_fig1_3B.log, replace ;

/* must first run dofile for HMD 1x1 Trates made using c:\users\accase\dropbox\HMD\dofiles\make_trate_1x1_update.do */

/***********************************************************/
/****** making US mortality rates by single year of age ****/
/***********************************************************/

/* the first file  comes directly from CDC bridged-race population website */
  use c:\aamortality102716\outfiles\wnh_pop_SY_4554_1990_2015.dta;
  gen year = real(Yearly_July_1st_Estimates_Code);
  gen age  = real(Age_Code);
  keep if year>=1990 & year<=2015;
  keep year age Population;
save `tempW1';

/*  count overall mortality by year and age for WNH   */

use "c:\aamortality102716\outfiles\mort_8915";
keep if age>=45 & age<=54;
keep if race==1;

keep  year age ;
keep if year>=1990 & year<=2015;
gen one=1;
bysort year age : egen Tmort  = total(one);
drop one;
by year age, sort:  keep if _n==1;

merge 1:1 year age using `tempW1' ;
drop _m;

gen Trate_SY = Tmort*100000/Population;
keep year age Trate_SY  Population ;
gen sex=0;
gen iso = "USW";
label data "WNH single year of age Trate 45-54 MF";
save `tempdat';


merge 1:1 year age sex iso using c:\users\accase\dropbox\hmd\data\Trate_1x1_update;
drop _m;
save `tempdat' , replace ;



/** age adusted using 2010 as a base year ************************************************/

keep if sex==0;
keep if year>=1989;
keep if age>=45 & age<=54;

gen Pop10=Population if year==2010;
bysort iso age sex: egen POP10=mean(Pop10);
bysort iso year sex: egen TPOP10 = total(POP10);
gen pct10= POP10/TPOP10 ;
gen T1 = Trate_SY*pct10;
bysort iso year sex: egen Trate_AA10 = total(T1);
replace Trate_AA10=. if Trate_AA10==0;
drop if Trate_AA10==.;


bysort year iso sex: keep if _n==1;
sort year;


gr two (line Trate_AA10 year if  iso=="USW", lcolor(red) lwidth(thick)) (line Trate_AA10 year if  iso=="FRA", lcolor(green) lwidth(medthick))
(line Trate_AA10 year if  iso=="GER", lcolor(midblue) lwidth(medthick)) (line Trate_AA10 year if  iso=="UK", lcolor(midgreen) lwidth(medthick))
(line Trate_AA10 year if  iso=="CAN", lcolor(lavender) lwidth(medthick)) (line Trate_AA10 year if  iso=="AUS", lcolor(maroon) lwidth(medthick))
(line Trate_AA10 year if  iso=="SWE", lcolor(navy) lwidth(medthick)), legend(off) graphregion(color(white)) ytitle("deaths per 100,100")
aspectratio(1.25) ysize(4.5) xsize(4) xtitle(year) title("Age-adjusted mortality rates", size(med) color(black))
subtitle("ages 45-54", size(medsmall));

*saving("Trate_AA10_4554_intl.gph", replace);
log close;
stop;


