cap log close
cap drop _all
set more off
# delimit ;

/* Figure 1.2 Brookings */
log using c:\users\accase\dropbox\brookings\archive\dofiles\graph_fig1_2.log, replace;
/* combining BNH and WNH mortality  rates by year age_gp sex edclass  */
/* EXCLUDING FOUR STATES THAT DON'T HAVE EDUCATION DATA IN EARLY 1990S ON DEATH CERTS: GA,OK,RI,SD */
/* for education work: don't use data prior to 1992 */
/* data for BNHrates and WNHrates were created using dofiles make_BNHrates_sex_5yr_state_ed_9215.do
   and make_WNHrates_sex_5yr_state_ed_9215.do */


tempfile tempdat;
use  c:\aamortality102716\outfiles\BNHrates_sex_5yr_state_ed_9215 ;
gen race=2;
save `tempdat';

use  c:\aamortality102716\outfiles\WNHrates_sex_5yr_state_ed_9215 ;
gen race=1;
merge 1:1 year race sex age_gp edclass using `tempdat';
drop if year<1993;

/* the following can be re-used, substituting different age groups in, to create all parts of Figure 1.2 */
gr two (line Trate year if race==1 & age==50 & sex==0 & edclass==1, lcolor(red) lwidth(thick))
       (line Trate year if race==2 & age==50 & sex==0 & edclass==1, lcolor(blue) lwidth(thick))
       , legend(off)   ysize(3.2) xsize(3.8) xtitle(year)
         graphregion(color(white)) ytitle("deaths per 100,000") title(50-54);
*saving(c:\aamortality102716\edresults\BNH_WNH_Trate1_50.gph, replace);

log close;
