cap log close
cap drop _all
set more off
log using c:\users\accase\dropbox\cepr_org\dofiles\make_ORG_rw_sex_ed_7915.log, replace
# delimit ;
/* combining cepr_org cps outgoing rotation group real wages 1979-2015 by sex and ed */

tempfile tempbig;

use c:\users\accase\dropbox\cepr_org\data\cepr_org_1979 ;
   keep if age>=20 & age<=69 ;
   keep rw rw_ot year age female educ orgwgt wbho state fipscounty ;
   save `tempbig';

forval i = 1980 (1) 2015 {;
  use "c:\users\accase\dropbox\cepr_org\data\cepr_org_`i'.dta" ;
  keep if age>=20 & age<=69 ;
  keep rw rw_ot year age female educ orgwgt wbho state fipscounty;
  append using `tempbig';
  save `tempbig', replace;
};
gen edclass=1 if educ<=2;
replace edclass=2 if educ==3;
replace edclass=3 if educ>=4 & educ<=5 ;
label def edlab 1 LEHS 2 SomeC 3 College;
label val edclass edlab;
label var edclass "LEHS SomeC College";

save c:\users\accase\dropbox\cepr_org\data\ORG_rw_sex_ed_7915.dta, replace;

log close;
stop;

