clear all
insheet using /Users/natashasarin/Dropbox/VladimirFolder/Natasha_Research/Banks/Data/output.txt

replace stock_price_cg = "0" if stock_price_cg == "#DIV/0!" 
replace cds_spread = "-1" if cds_spread == "(Invalid Identifier)" 
destring stock_price_cg, replace
destring cds_spread, replace 
gen year = substr(date, 1, 4)
destring year, replace

gen price_to_book = stock_price/book_value_ps 
gen crisis = . 
replace crisis = 0 if year == 2002 | year == 2003 | year == 2004 | year == 2005 | year == 2006 | year == 2007 
replace crisis = 1 if year == 2010 | year == 2011 | year == 2012 | year == 2013 | year == 2014 

by bank year, sort: egen beta_average_2014 = mean(beta) if year == 2014  
by bank crisis, sort: egen beta_average_pre = mean(beta) if crisis == 0 
by bank crisis, sort: egen beta_average_post = mean(beta) if crisis == 1 

by bank year, sort: egen ptb_average_2014 = mean(price_to_book) if year == 2014  
by bank crisis, sort: egen ptb_average_pre = mean(price_to_book) if crisis == 0 
by bank crisis, sort: egen ptb_average_post = mean(price_to_book) if crisis == 1 

br year crisis bank beta beta_average_pre beta_average_post 
br year crisis bank price_to_book ptb_average_pre ptb_average_post ptb_average_2014 

by bank crisis, sort: gen output_indicator = _n 
replace output_indicator = 0 if output_indicator != 1

by bank year, sort: gen output_year = _n 
replace output_year = 0 if output_year != 1 
replace output_year = 0 if year != 2014

br bank year crisis beta price_to_book beta_average_pre beta_average_post beta_average_2014 ptb_average_pre ptb_average_post ptb_average_2014 if output_indicator == 1 | output_year == 1  
