from tools import *

dates = file_to_list('dates.txt')
core  = file_to_list('core.txt')

K = len(core[0])

fields = ['','ID','BANK','IQ_COMPANY_NAME','COUNTRY','LOCAL_IDX','TICKER']
series = ['index','stock_price','beta','index_cg','stock_price_cg','book_value_ps','cds_spread']

def get_value(my_source,my_core_item,my_date):
	N = len(source[0])
	
	# find row
	row_found = False
	for i in range(1,len(my_source)):
		if source[i][:K]==my_core_item:
			row_found = True
			break
	
	if not row_found: return 'NOT FOUND'
	
	# find column
	column_found = False
	for j in range(N):
		if my_source[0][j]==my_date:
			column_found = True
			break
	
	if not column_found: return 'NOT FOUND'
	return my_source[i][j]

sources = []
for s_id in [1,2,3,4,5,6,7]:
	source_file = 'data_%i.txt' % (s_id)
	source = file_to_list(source_file)
	sources.append(source)

output = ''

for core_item in core:
	print core_item
	for date in dates:
		msg = '\t'.join(core_item) + '\t' + date
		for source in sources:
			value = get_value(source,core_item,date)
			msg = msg + '\t' + value
		output = output + msg + '\n'

open('output.txt','w').write(output)
