% EXCESS STOCK RETURNS: portfolios and individual stocks
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% Monthly average value weighted returns with dividends 
% from Fama and French industry portfolios relative to 
% value-weighted S&P 500 stock return (benchmark portfolio)

load industry_stock_returns.txt

portfolio=industry_stock_returns;
t1=(2014+7/12:1/12:2015+12/12)';

%compute cumulative growth rates

for jj=1:size(portfolio,2)
    a(1,1)=1;
    for jx=1:size(portfolio,1)
         a(jx+1,1)=(1+portfolio(jx,jj))*a(jx,1);
         cum_g_portfolio(1,jj)=100*(a(end,1)-1);
    end
    p_ann_rate(1,jj)=100*(((1+((1+(cum_g_portfolio(1,jj)/100))^(1/18)-1))^12)-1);
end


% Monthly average value weighted returns with dividends 
% for individual stocks from Bloomberg relative to 
% value-weighted S&P 500 stock return (benchmark portfolio)

load individual_stock_returns1.txt

individual1=individual_stock_returns1;
t2=(2014+7/12:1/12:2016+3/12)';

%compute cumulative growth rates

for jj=1:size(individual1,2)
    a(1,1)=1;
    for jx=1:size(individual1,1)
         a(jx+1,1)=(1+individual1(jx,jj))*a(jx,1);
         cum_g_individual1(1,jj)=100*(a(end,1)-1);
    end
    i_ann_rate1(1,jj)=100*(((1+((1+(cum_g_individual1(1,jj)/100))^(1/21)-1))^12)-1);
end

load individual_stock_returns2.txt

individual2=individual_stock_returns2;

%compute cumulative growth rates

for jj=1:size(individual2,2)
    a(1,1)=1;
    for jx=1:size(individual2,1)
         a(jx+1,1)=(1+individual2(jx,jj))*a(jx,1);
         cum_g_individual2(1,jj)=100*(a(end,1)-1);
    end
    i_ann_rate2(1,jj)=100*(((1+((1+(cum_g_individual2(1,jj)/100))^(1/21)-1))^12)-1);
end

disp('Candy and Soda:') 
disp(p_ann_rate(1,3))

disp('Beer and Liquor:')
disp(p_ann_rate(1,4))

disp('Tobacco:')
disp(p_ann_rate(1,5))

disp('Food Products:')
disp(p_ann_rate(1,2))

disp('Apparel:')
disp(p_ann_rate(1,10))

disp('Tourism:')
disp(mean(i_ann_rate1(1,16:22)))

disp('Restaurants, Hotels, and Motels:')
disp(p_ann_rate(1,44))

disp('Retail Sales:')
disp(p_ann_rate(1,43))
disp('Amazon:')
disp(i_ann_rate1(1,10))

disp('Home Depot:')
disp(i_ann_rate1(1,14))

disp('Petroleum and Natural Gas Sector:')
disp(p_ann_rate(1,30))

disp('Rubber and Plastics:')
disp(p_ann_rate(1,15))

disp('Logistics:')
disp(mean(i_ann_rate2(1,13:14)))

disp('Chemicals:')
disp(p_ann_rate(1,14))

disp('Airlines:')
disp(mean(i_ann_rate2(1,9:12)))

disp('Textiles:')
disp(p_ann_rate(1,16))

disp('Auto Companies:')
disp(p_ann_rate(1,23))

disp('Agriculture:')
disp(p_ann_rate(1,1))

disp('Mining:')
disp(p_ann_rate(1,28))

disp('Steel:')
disp(p_ann_rate(1,19))

disp('Fabricated Metal Products:')
disp(p_ann_rate(1,20))

disp('Machinery:')
disp(p_ann_rate(1,21))

disp('Shipbuilding and Railroad Equipment:')
disp(p_ann_rate(1,25))