% FIGURE9.M
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% Standard deviation across survey responses to one and five year gasoline
% price expectations, courtesy of Richard Curtin, MSC
load oneyearstd.txt;
load fiveyearstd.txt;

time=2006+2/12:1/12:2016+3/12;
plot(time,oneyearstd,'b-',time,fiveyearstd,'r:','linewidth',3)
legend('1 Year Ahead','5 Years Ahead','Location','North')
ylabel('Cents/Gallon','fontsize',18)
axis([time(1) time(end) 0 120])
grid on
line([(2014+6/12) (2014+6/12)], [-5000 5000],'linewidth',2)
line([(2015+1/12) (2015+1/12)], [-5000 5000],'linewidth',2)

