% FIGURE8.M
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% FRED/BLS: Median duration of unemployment in weeks, SA, monthly data
% 1980.1-2016.3
load duration.txt

% FRED/BLS: civilian U.S. unemployment rate in percent, monthly data
% 1980.1-2016.3
load urate.txt

time=1980+1/12:1/12:2016+3/12;
subplot(1,2,1)
plot(time,urate(:,3),'linewidth',2)
axis([time(1) time(end) 0 13])
ylabel('Percent','fontsize',16)
title('U.S. Unemployment Rate','fontsize',16)
line([(2014+6/12) (2014+6/12)], [-5000 100000],'linewidth',2)
line([(1985+12/12) (1985+12/12)], [-5000 100000],'linewidth',2)
grid on

subplot(1,2,2)
plot(time,duration(:,3),'linewidth',2)
axis([time(1) time(end) 0 30])
title('Median Duration of Unemployment','fontsize',16)
ylabel('Weeks','fontsize',16)
line([(2014+6/12) (2014+6/12)], [-5000 100000],'linewidth',2)
line([(1985+12/12) (1985+12/12)], [-5000 100000],'linewidth',2)
grid on
