% FIGURE7.M
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% Percent changes in real U.S. price for gasoline and other motor fuel
time=1970+2/12:1/12:2016+3/12;
load pgasdefl.txt; % PCE deflator for gasoline and other motor fuel
load pcedefl.txt;  % Overall PCE deflator
rpgas=pgasdefl./pcedefl;
drpgas=(rpgas(2:end)-rpgas(1:end-1,:))./rpgas(1:end-1,:);
subplot(3,1,1)
plot(time,drpgas*100,time,zeros(size(time)),'k-','linewidth',2)
title('Changes in U.S. Real Price of Gasoline and Other Motor Fuel','fontsize',17)
ylabel('Percent','fontsize',18)
axis([time(1) time(end) -30 30])
grid on;

% Share of gasoline and motor fuel in total PCE expenditures
time=1970+1/12:1/12:2016+3/12;
load pcetotal.txt; % Total nominal consumer expenditures
load pcegas.txt;   % Gasoline and motor fuel consumer expenditures
share=pcegas./pcetotal;
subplot(3,1,2)
plot(time,share*100,time,mean(share*100)*ones(size(time)),'k-','linewidth',2)
title('Share of Gasoline in Total Consumer Expenditures','fontsize',17)
ylabel('Percent','fontsize',18)
axis([time(1) time(end) 0 6])
grid on;

% Purchasing power loss analogous to Edelstein and Kilian (JME 2009):
% defined as: - drpgas x (share of gasline in total PCE)
time=1970+2/12:1/12:2016+3/12;
pploss=-drpgas.*share(2:end);
subplot(3,1,3)
plot(time,pploss*100,time,zeros(size(time)),'k-','linewidth',2)
title('Shocks to U.S. Consumers Purchasing Power','fontsize',17)
ylabel('Percent','fontsize',18)
axis([time(1) time(end) -0.75 0.75])
grid on;
