% FIGURE6.M
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% Michigan Survey of Consumers (MSC):
% Now thinking only about the next twelve months, do you think that the 
% price of gasoline will go up during the next twelve months, will gasoline
% prices go down, or will they stay about the same as they are now? 
%
% About how many cents per gallon do you think gasoline prices will 
%(increase/decrease) during the next twelve months compared to now? 

% 2006.2-2016.3, Need to express gas expectation as actual price in cents
% plus expected change in cents

% Average U.S. retail gas price, all grades, MER, Table 9.4, column 4
% 2006.2-2016.3
load avgasprice.txt; avgasprice=avgasprice*100;

% MSC, monthly, 2006.2-2016.3, 1 year ahead expectations of change in 
% gasoline price in cents
load msc1y_changegasprice.txt;
exppgas=msc1y_changegasprice;

% Plot against real random walk with MSC 1-year ahead inflation expectation
load msc1y_infl.txt;
time=2006+2/12:1/12:2016+3/12;
plot(time,avgasprice+exppgas,'b-',time,avgasprice.*(1+msc1y_infl/100),'r:','linewidth',3)
axis([time(1) time(end) 0 500])
grid on
ylabel('Cents','fontsize',20)
legend('Current Gas Price + MSC Expected Change in Gas Price','Current Gas Price + MSC Inflation Expectation','Location','best')