% FIGURE4.M
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% Compute total U.S. consumption of motor gasoline in 1000 bd as sum of
% consumption by transport sector, industrial sector, and commerical sector
% Source: MER Table 3.7, 1973.1-2016.3

% motorgas=(transport+industrial+commercial)/1000;
load motorgas.txt;  % contains seasonally adjusted data

lmotorgas=log(motorgas); growth=(lmotorgas(2:end)-lmotorgas(1:end-1))*100; growth=growth(end-17-4+1:end);
time=2014+7/12:1/12:2016+3/12;
plot(time(1:end),cumsum(growth),'b-',time(1:end),zeros(size(time(1:end))),'k-','linewidth',3)
axis([time(1) time(end) -6 10])
ylabel('Percent','fontsize',20)
grid on
set(gca,'XTick',[2014+5/12 2016+4/12])
text(2014+7/12,-6.5,'Jul','hor','center','fontsize',12)
text(2014+9/12,-6.5,'Sep','hor','center','fontsize',12)
text(2014+11/12,-6.5,'Nov','hor','center','fontsize',12)
text(2015+1/12,-6.5,'Jan','hor','center','fontsize',12)
text(2015+3/12,-6.5,'Mar','hor','center','fontsize',12)
text(2015+5/12,-6.5,'May','hor','center','fontsize',12)
text(2015+7/12,-6.5,'Jul','hor','center','fontsize',12)
text(2015+9/12,-6.5,'Sep','hor','center','fontsize',12)
text(2015+11/12,-6.5,'Nov','hor','center','fontsize',12)
text(2016+1/12,-6.5,'Jan','hor','center','fontsize',12)
text(2016+3/12,-6.5,'Mar','hor','center','fontsize',12)
