% FIGURE3.M
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% EIA breakdown, 2000.1-2016.3, Gasoline and Diesel Fuel Update, Gasoline
% Pump Components History
load eiagasprice.txt;
load eiaoilshare.txt;
eiaoilcost=eiagasprice.*(eiaoilshare/100);
load eiataxshare.txt;
eiagastax=eiagasprice.*(eiataxshare/100);

% Index since June 2014
pretaxprice=eiagasprice(174:end)-eiagastax(174:end);
time=2014+6/12:1/12:2016+3/12;
plot(time,100*eiagasprice(174:end)/eiagasprice(174),'b-',time,100*eiaoilcost(174:end)/eiaoilcost(174),'r:',time,100*pretaxprice/pretaxprice(1),'k-.','linewidth',3)
legend('Price of Motor Gasoline per Gallon','Cost of Crude Oil per Gallon','Pre-Tax Price per Gallon')
ylabel('Index: June 2014 = 100','fontsize',18)
axis([time(1) time(end) 0 1.1*100])
grid on
set(gca,'XTick',[2014+5/12 2016+4/12])
text(2014+6/12,-5,'Jun','hor','center','fontsize',12)
text(2014+8/12,-5,'Aug','hor','center','fontsize',12)
text(2014+10/12,-5,'Oct','hor','center','fontsize',12)
text(2014+12/12,-5,'Dec','hor','center','fontsize',12)
text(2015+2/12,-5,'Feb','hor','center','fontsize',12)
text(2015+4/12,-5,'Apr','hor','center','fontsize',12)
text(2015+6/12,-5,'Jun','hor','center','fontsize',12)
text(2015+8/12,-5,'Aug','hor','center','fontsize',12)
text(2015+10/12,-5,'Oct','hor','center','fontsize',12)
text(2015+12/12,-5,'Dec','hor','center','fontsize',12)
text(2016+2/12,-5,'Feb','hor','center','fontsize',12)





