% FIGURE2.M
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% EIA breakdown, 2000.1-2016.3, Gasoline and Diesel Fuel Update, Gasoline
% Pump Components History
load eiagasprice.txt;
load eiaoilshare.txt;
eiaoilcost=eiagasprice.*(eiaoilshare/100);
load eiataxshare.txt;
eiagastax=eiagasprice.*(eiataxshare/100);

time=2000+1/12:1/12:2016+3/12;
plot(time,eiagasprice,'b-',time,eiaoilcost,'r:','linewidth',3)
axis([time(1) time(end) 0 4.5])
ylabel('Dollar per Gallon','fontsize',18)
legend('Price of Motor Gasoline','Cost of Crude Oil')
grid on

