% FIGURE11.M
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% BEA SA, millions, 1976.1-2016.3
load autosales.txt;   % Auto sales, total
load ltrucksales.txt; % Light truck sales, total

time=1976+1/12:1/12:2016+3/12;
subplot(1,2,1)
plot(time,autosales,'b-',time,ltrucksales,'r:','linewidth',2)
axis([2010+1/12 time(end) 0 12])
grid on
legend('Autos','Light trucks')
line([(2014+6/12) (2014+6/12)], [-5000 100000],'linewidth',2)
ylabel('Millions','fontsize',20)

% 2010.1-2016.3, monthly 
% Sales of 
% Hybrids (HEVs)	Plug-in Hybrid (PHEVs) & Extended Range (EREVs)	Battery (BEVs)	Total Electric Drive Vehicles
% Number of cars
load electrics.txt;
time=2010+1/12:1/12:2016+3/12;
subplot(1,2,2)
electrics=electrics/1000000;
plot(time,electrics(:,1),'b:',time,electrics(:,2),'r:',time,electrics(:,3),'b-.',time,electrics(:,4),'k-','linewidth',2)
axis([time(1) time(end) 0 0.08])
grid on
legend('HEV','PHEV+EREV','BEV','All')
line([(2014+6/12) (2014+6/12)], [-5000 100000],'linewidth',2)
ylabel('Millions','fontsize',20)

